/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.database.arenas.provider;

import java.io.IOException;
import java.util.List;
import me.glaremasters.guilds.arena.Arena;
import me.glaremasters.guilds.database.arenas.ArenaProvider;
import me.glaremasters.guilds.database.arenas.ArenaRowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.config.RegisterRowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.customizer.Bind;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.customizer.Define;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.SqlQuery;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jetbrains.annotations.NotNull;

public interface ArenaSQLiteProvider
extends ArenaProvider {
    @Override
    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS <prefix>arena (\n  `id` VARCHAR(36) NOT NULL,\n  `data` JSON NOT NULL,\n  PRIMARY KEY (`id`),\n  UNIQUE (`id`));")
    public void createContainer(@Define(value="prefix") @NotNull String var1);

    @Override
    @SqlQuery(value="SELECT EXISTS(SELECT 1 FROM <prefix>arena WHERE id = :id)")
    public boolean arenaExists(@Define(value="prefix") @NotNull String var1, @Bind(value="id") @NotNull String var2) throws IOException;

    @Override
    @SqlQuery(value="SELECT id FROM <prefix>arena")
    public List<String> getAllArenaIds(@Define(value="prefix") @NotNull String var1) throws IOException;

    @Override
    @SqlQuery(value="SELECT * FROM <prefix>arena")
    @RegisterRowMapper(value=ArenaRowMapper.class)
    public List<Arena> getAllArenas(@Define(value="prefix") @NotNull String var1);

    @Override
    @SqlQuery(value="SELECT * FROM <prefix>arena WHERE id = :id")
    @RegisterRowMapper(value=ArenaRowMapper.class)
    public Arena getArena(@Define(value="prefix") @NotNull String var1, @Bind(value="id") @NotNull String var2) throws IOException;

    @Override
    @SqlUpdate(value="INSERT INTO <prefix>arena(id, data) VALUES (:id, :data)")
    public void createArena(@Define(value="prefix") @NotNull String var1, @Bind(value="id") String var2, @Bind(value="data") String var3);

    @Override
    @SqlUpdate(value="UPDATE <prefix>arena SET data = :data WHERE id = :id")
    public void updateArena(@Define(value="prefix") @NotNull String var1, @Bind(value="id") @NotNull String var2, @Bind(value="data") @NotNull String var3) throws IOException;

    @Override
    @SqlUpdate(value="DELETE FROM <prefix>arena WHERE id = :id")
    public void deleteArena(@Define(value="prefix") @NotNull String var1, @Bind(value="id") @NotNull String var2) throws IOException;
}

