/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.database.challenges;

import java.io.File;
import java.lang.reflect.Type;
import java.util.Set;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.database.DatabaseAdapter;
import me.glaremasters.guilds.database.DatabaseBackend;
import me.glaremasters.guilds.database.challenges.ChallengeProvider;
import me.glaremasters.guilds.database.challenges.provider.ChallengeJsonProvider;
import me.glaremasters.guilds.guild.GuildChallenge;
import org.jetbrains.annotations.NotNull;

public class ChallengeAdapter {
    private final ChallengeProvider provider;
    private String sqlTablePrefix;

    public ChallengeAdapter(Guilds guilds, DatabaseAdapter databaseAdapter) {
        DatabaseBackend databaseBackend = databaseAdapter.getBackend();
        switch (databaseBackend) {
            default: {
                File file = new File(guilds.getDataFolder(), "challenges");
                this.provider = new ChallengeJsonProvider(file);
                break;
            }
            case MYSQL: 
            case SQLITE: 
            case MARIADB: {
                this.sqlTablePrefix = databaseAdapter.getSqlTablePrefix();
                this.provider = databaseAdapter.getDatabaseManager().getJdbi().onDemand(databaseBackend.getChallengeProvider());
            }
        }
    }

    public void createContainer() {
        this.provider.createContainer(this.sqlTablePrefix);
    }

    public boolean challengeExists(@NotNull String string) {
        return this.provider.challengeExists(this.sqlTablePrefix, string);
    }

    public Set<GuildChallenge> getAllChallenges() {
        return this.provider.getAllChallenges(this.sqlTablePrefix);
    }

    public GuildChallenge getChallenge(@NotNull String string) {
        return this.provider.getChallenge(this.sqlTablePrefix, string);
    }

    public void saveChallenges(@NotNull Set<GuildChallenge> set) {
        for (GuildChallenge guildChallenge : set) {
            this.saveChallenge(guildChallenge);
        }
    }

    public void saveChallenge(@NotNull GuildChallenge guildChallenge) {
        if (!this.challengeExists(guildChallenge.getId().toString())) {
            this.createChallenge(guildChallenge);
        } else {
            this.updateChallenge(guildChallenge);
        }
    }

    public void createChallenge(@NotNull GuildChallenge guildChallenge) {
        this.provider.createChallenge(this.sqlTablePrefix, guildChallenge.getId().toString(), Guilds.getGson().toJson((Object)guildChallenge, (Type)((Object)GuildChallenge.class)));
    }

    public void updateChallenge(@NotNull GuildChallenge guildChallenge) {
        this.provider.updateChallenge(this.sqlTablePrefix, guildChallenge.getId().toString(), Guilds.getGson().toJson((Object)guildChallenge, (Type)((Object)GuildChallenge.class)));
    }

    public void deleteChallenge(@NotNull String string) {
        this.provider.deleteChallenge(this.sqlTablePrefix, string);
    }
}

