/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.guis;

import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.cooldowns.CooldownHandler;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guis.BuffGUI;
import me.glaremasters.guilds.guis.InfoGUI;
import me.glaremasters.guilds.guis.ListGUI;
import me.glaremasters.guilds.guis.MembersGUI;
import me.glaremasters.guilds.guis.VaultGUI;
import me.glaremasters.guilds.libs.commands.PaperCommandManager;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lme/glaremasters/guilds/guis/GUIHandler;", "", "guilds", "Lme/glaremasters/guilds/Guilds;", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "commandManager", "Lme/glaremasters/guilds/libs/commands/PaperCommandManager;", "cooldownHandler", "Lme/glaremasters/guilds/cooldowns/CooldownHandler;", "(Lme/glaremasters/guilds/Guilds;Lch/jalu/configme/SettingsManager;Lme/glaremasters/guilds/guild/GuildHandler;Lco/aikar/commands/PaperCommandManager;Lme/glaremasters/guilds/cooldowns/CooldownHandler;)V", "buffs", "Lme/glaremasters/guilds/guis/BuffGUI;", "getBuffs", "()Lme/glaremasters/guilds/guis/BuffGUI;", "info", "Lme/glaremasters/guilds/guis/InfoGUI;", "getInfo", "()Lme/glaremasters/guilds/guis/InfoGUI;", "list", "Lme/glaremasters/guilds/guis/ListGUI;", "getList", "()Lme/glaremasters/guilds/guis/ListGUI;", "members", "Lme/glaremasters/guilds/guis/MembersGUI;", "getMembers", "()Lme/glaremasters/guilds/guis/MembersGUI;", "vaults", "Lme/glaremasters/guilds/guis/VaultGUI;", "getVaults", "()Lme/glaremasters/guilds/guis/VaultGUI;", "Guilds"})
public final class GUIHandler {
    @NotNull
    private final BuffGUI buffs;
    @NotNull
    private final ListGUI list;
    @NotNull
    private final InfoGUI info;
    @NotNull
    private final MembersGUI members;
    @NotNull
    private final VaultGUI vaults;

    public GUIHandler(@NotNull Guilds guilds, @NotNull SettingsManager settingsManager, @NotNull GuildHandler guildHandler, @NotNull PaperCommandManager paperCommandManager, @NotNull CooldownHandler cooldownHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"guilds");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"guildHandler");
        Intrinsics.checkNotNullParameter((Object)paperCommandManager, (String)"commandManager");
        Intrinsics.checkNotNullParameter((Object)cooldownHandler, (String)"cooldownHandler");
        SettingsManager settingsManager2 = guilds.getSettingsHandler().getBuffConf();
        Intrinsics.checkNotNullExpressionValue((Object)settingsManager2, (String)"guilds.settingsHandler.buffConf");
        this.buffs = new BuffGUI(settingsManager2, cooldownHandler);
        this.list = new ListGUI(guilds, settingsManager, guildHandler);
        this.info = new InfoGUI(guilds, settingsManager, guildHandler, cooldownHandler, paperCommandManager);
        this.members = new MembersGUI(guilds, settingsManager, guildHandler);
        this.vaults = new VaultGUI(guilds, settingsManager, guildHandler);
    }

    @NotNull
    public final BuffGUI getBuffs() {
        return this.buffs;
    }

    @NotNull
    public final ListGUI getList() {
        return this.list;
    }

    @NotNull
    public final InfoGUI getInfo() {
        return this.info;
    }

    @NotNull
    public final MembersGUI getMembers() {
        return this.members;
    }

    @NotNull
    public final VaultGUI getVaults() {
        return this.vaults;
    }
}

