/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme;

import javax.annotation.Nullable;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.configme.configurationdata.ConfigurationData;
import me.glaremasters.guilds.libs.configme.migration.MigrationService;
import me.glaremasters.guilds.libs.configme.properties.Property;
import me.glaremasters.guilds.libs.configme.resource.PropertyReader;
import me.glaremasters.guilds.libs.configme.resource.PropertyResource;

public class SettingsManagerImpl
implements SettingsManager {
    private final ConfigurationData configurationData;
    private final PropertyResource resource;
    private final MigrationService migrationService;

    protected SettingsManagerImpl(PropertyResource propertyResource, ConfigurationData configurationData, @Nullable MigrationService migrationService) {
        this.configurationData = configurationData;
        this.resource = propertyResource;
        this.migrationService = migrationService;
        this.loadFromResourceAndValidate();
    }

    @Override
    public <T> T getProperty(Property<T> property) {
        return this.configurationData.getValue(property);
    }

    @Override
    public <T> void setProperty(Property<T> property, T t) {
        this.configurationData.setValue(property, t);
    }

    @Override
    public void reload() {
        this.loadFromResourceAndValidate();
    }

    @Override
    public void save() {
        this.resource.exportProperties(this.configurationData);
    }

    protected void loadFromResourceAndValidate() {
        PropertyReader propertyReader = this.resource.createReader();
        this.configurationData.initializeValues(propertyReader);
        if (this.migrationService != null && this.migrationService.checkAndMigrate(propertyReader, this.configurationData)) {
            this.save();
        }
    }

    protected final PropertyResource getPropertyResource() {
        return this.resource;
    }

    protected final ConfigurationData getConfigurationData() {
        return this.configurationData;
    }

    @Nullable
    protected final MigrationService getMigrationService() {
        return this.migrationService;
    }
}

