/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.beanmapper.leafvaluehandler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import me.glaremasters.guilds.libs.configme.beanmapper.leafvaluehandler.LeafValueHandler;
import me.glaremasters.guilds.libs.configme.utils.TypeInformation;

public class CombiningLeafValueHandler
implements LeafValueHandler {
    private final Collection<LeafValueHandler> handlers;

    public CombiningLeafValueHandler(LeafValueHandler ... leafValueHandlerArray) {
        this(Arrays.asList(leafValueHandlerArray));
    }

    public CombiningLeafValueHandler(Collection<LeafValueHandler> collection) {
        this.handlers = Collections.unmodifiableCollection(collection);
    }

    @Override
    public Object convert(TypeInformation typeInformation, Object object) {
        return this.getFirstNonNull(leafValueHandler -> leafValueHandler.convert(typeInformation, object));
    }

    @Override
    public Object toExportValue(Object object) {
        return this.getFirstNonNull(leafValueHandler -> leafValueHandler.toExportValue(object));
    }

    protected final Collection<LeafValueHandler> getHandlers() {
        return this.handlers;
    }

    private Object getFirstNonNull(Function<LeafValueHandler, Object> function) {
        return this.handlers.stream().map(function).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

