/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.beanmapper.leafvaluehandler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import me.glaremasters.guilds.libs.configme.beanmapper.leafvaluehandler.AbstractLeafValueHandler;

public class NumberLeafValueHandler
extends AbstractLeafValueHandler {
    private static final Map<Class<?>, Function<Number, Number>> NUMBER_CLASSES_TO_CONVERSION = NumberLeafValueHandler.createMapOfTypeToTransformFunction();

    @Override
    public Object convert(Class<?> clazz, Object object) {
        if (object instanceof Number) {
            Function<Number, Number> function = NUMBER_CLASSES_TO_CONVERSION.get(clazz);
            return function == null ? (Number)null : (Number)function.apply((Number)object);
        }
        return null;
    }

    @Override
    public Object toExportValue(Object object) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = object == null ? null : object.getClass();
        if (NUMBER_CLASSES_TO_CONVERSION.containsKey(clazz)) {
            return object;
        }
        return null;
    }

    private static Map<Class<?>, Function<Number, Number>> createMapOfTypeToTransformFunction() {
        HashMap<Class<Double>, Function<Number, Number>> hashMap = new HashMap<Class<Double>, Function<Number, Number>>();
        hashMap.put(Byte.TYPE, Number::byteValue);
        hashMap.put(Byte.class, Number::byteValue);
        hashMap.put(Short.TYPE, Number::shortValue);
        hashMap.put(Short.class, Number::shortValue);
        hashMap.put(Integer.TYPE, Number::intValue);
        hashMap.put(Integer.class, Number::intValue);
        hashMap.put(Long.TYPE, Number::longValue);
        hashMap.put(Long.class, Number::longValue);
        hashMap.put(Float.TYPE, Number::floatValue);
        hashMap.put(Float.class, Number::floatValue);
        hashMap.put(Double.TYPE, Number::doubleValue);
        hashMap.put(Double.class, Number::doubleValue);
        return Collections.unmodifiableMap(hashMap);
    }
}

