/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.properties;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import me.glaremasters.guilds.libs.configme.properties.BaseProperty;
import me.glaremasters.guilds.libs.configme.properties.convertresult.ConvertErrorRecorder;
import me.glaremasters.guilds.libs.configme.properties.types.PropertyType;
import me.glaremasters.guilds.libs.configme.resource.PropertyReader;

public class MapProperty<V>
extends BaseProperty<Map<String, V>> {
    private final PropertyType<V> type;

    public MapProperty(String string, Map<String, V> map, PropertyType<V> propertyType) {
        super(string, Collections.unmodifiableMap(map));
        Objects.requireNonNull(propertyType, "type");
        this.type = propertyType;
    }

    @Override
    protected Map<String, V> getFromReader(PropertyReader propertyReader, ConvertErrorRecorder convertErrorRecorder) {
        Object object = propertyReader.getObject(this.getPath());
        if (!(object instanceof Map)) {
            return null;
        }
        Map map = (Map)object;
        LinkedHashMap<String, V> linkedHashMap = new LinkedHashMap<String, V>();
        for (Map.Entry entry : map.entrySet()) {
            String string = entry.getKey().toString();
            V v = this.type.convert(entry.getValue(), convertErrorRecorder);
            if (v == null) continue;
            linkedHashMap.put(string, v);
        }
        return this.postProcessMap(linkedHashMap);
    }

    @Override
    public Object toExportValue(Map<String, V> map) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, V> entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey(), this.type.toExportValue(entry.getValue()));
        }
        return linkedHashMap;
    }

    protected Map<String, V> postProcessMap(Map<String, V> map) {
        return Collections.unmodifiableMap(map);
    }
}

