/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.properties;

import java.util.Optional;
import me.glaremasters.guilds.libs.configme.properties.Property;
import me.glaremasters.guilds.libs.configme.properties.convertresult.PropertyValue;
import me.glaremasters.guilds.libs.configme.resource.PropertyReader;

public class OptionalProperty<T>
implements Property<Optional<T>> {
    private final Property<T> baseProperty;
    private final Optional<T> defaultValue;

    public OptionalProperty(Property<T> property) {
        this.baseProperty = property;
        this.defaultValue = Optional.empty();
    }

    public OptionalProperty(Property<T> property, T t) {
        this.baseProperty = property;
        this.defaultValue = Optional.of(t);
    }

    @Override
    public String getPath() {
        return this.baseProperty.getPath();
    }

    @Override
    public PropertyValue<Optional<T>> determineValue(PropertyReader propertyReader) {
        PropertyValue<T> propertyValue = this.baseProperty.determineValue(propertyReader);
        Optional optional = propertyValue.isValidInResource() ? Optional.ofNullable(propertyValue.getValue()) : Optional.empty();
        boolean bl = !propertyValue.isValidInResource() && propertyReader.contains(this.baseProperty.getPath());
        return bl ? PropertyValue.withValueRequiringRewrite(optional) : PropertyValue.withValidValue(optional);
    }

    @Override
    public Optional<T> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isValidValue(Optional<T> optional) {
        if (optional == null) {
            return false;
        }
        return optional.map(this.baseProperty::isValidValue).orElse(true);
    }

    @Override
    public Object toExportValue(Optional<T> optional) {
        return optional.map(this.baseProperty::toExportValue).orElse(null);
    }
}

