/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import me.glaremasters.guilds.libs.configme.properties.BaseProperty;
import me.glaremasters.guilds.libs.configme.properties.convertresult.ConvertErrorRecorder;
import me.glaremasters.guilds.libs.configme.properties.types.PropertyType;
import me.glaremasters.guilds.libs.configme.resource.PropertyReader;

public class SetProperty<T>
extends BaseProperty<Set<T>> {
    private final PropertyType<T> type;

    @SafeVarargs
    public SetProperty(String string, PropertyType<T> propertyType, T ... TArray) {
        this(string, propertyType, SetProperty.newSet(TArray));
    }

    public SetProperty(String string, PropertyType<T> propertyType, Set<T> set) {
        super(string, Collections.unmodifiableSet(set));
        Objects.requireNonNull(propertyType, "type");
        this.type = propertyType;
    }

    @Override
    protected Set<T> getFromReader(PropertyReader propertyReader, ConvertErrorRecorder convertErrorRecorder) {
        List<?> list2 = propertyReader.getList(this.getPath());
        if (list2 != null) {
            return list2.stream().map(object -> this.type.convert(object, convertErrorRecorder)).filter(Objects::nonNull).collect(this.setCollector());
        }
        return null;
    }

    @Override
    public Object toExportValue(Set<T> set) {
        return set.stream().map(this.type::toExportValue).collect(Collectors.toList());
    }

    protected Collector<T, ?, Set<T>> setCollector() {
        return Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet);
    }

    private static <E> Set<E> newSet(E[] EArray) {
        return Arrays.stream(EArray).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

