/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.utils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public class TypeInformation {
    @Nullable
    private final Type type;

    public TypeInformation(Type type) {
        this.type = type;
    }

    public static TypeInformation fromField(Field field) {
        return new TypeInformation(field.getGenericType());
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    public Class<?> getSafeToWriteClass() {
        return this.getSafeToWriteClassInternal(this.type);
    }

    public Class<?> getSafeToReadClass() {
        Class<?> clazz = this.getSafeToReadClassInternal(this.type);
        return clazz == null ? Object.class : clazz;
    }

    @Nullable
    public TypeInformation getGenericType(int n) {
        if (this.type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.type;
            return parameterizedType.getActualTypeArguments().length > n ? new TypeInformation(parameterizedType.getActualTypeArguments()[n]) : null;
        }
        return null;
    }

    @Nullable
    public Class<?> getGenericTypeAsClass(int n) {
        TypeInformation typeInformation = this.getGenericType(n);
        return typeInformation == null ? null : typeInformation.getSafeToWriteClass();
    }

    @Nullable
    private Class<?> getSafeToWriteClassInternal(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        return null;
    }

    @Nullable
    private Class<?> getSafeToReadClassInternal(Type type) {
        Class<?> clazz = this.getSafeToWriteClassInternal(type);
        if (clazz != null) {
            return clazz;
        }
        Type[] typeArray = null;
        if (type instanceof WildcardType) {
            typeArray = ((WildcardType)type).getUpperBounds();
        } else if (type instanceof TypeVariable) {
            typeArray = ((TypeVariable)type).getBounds();
        }
        if (typeArray != null) {
            return Arrays.stream(typeArray).map(this::getSafeToReadClassInternal).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    public String toString() {
        return "TypeInformation[type=" + this.type + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TypeInformation) {
            TypeInformation typeInformation = (TypeInformation)object;
            return Objects.equals(this.type, typeInformation.type);
        }
        return false;
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.hashCode();
    }
}

