/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.gui.components.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.glaremasters.guilds.libs.gui.components.GuiType;
import me.glaremasters.guilds.libs.gui.components.exception.GuiException;
import me.glaremasters.guilds.libs.gui.guis.BaseGui;
import me.glaremasters.guilds.libs.gui.guis.GuiItem;
import me.glaremasters.guilds.libs.gui.guis.PaginatedGui;
import org.jetbrains.annotations.NotNull;

public final class GuiFiller {
    private final BaseGui gui;

    public GuiFiller(BaseGui baseGui) {
        this.gui = baseGui;
    }

    public void fillTop(@NotNull GuiItem guiItem) {
        this.fillTop(Collections.singletonList(guiItem));
    }

    public void fillTop(@NotNull List<GuiItem> list2) {
        List<GuiItem> list3 = this.repeatList(list2);
        for (int i = 0; i < 9; ++i) {
            if (this.gui.getGuiItems().containsKey(i)) continue;
            this.gui.setItem(i, list3.get(i));
        }
    }

    public void fillBottom(@NotNull GuiItem guiItem) {
        this.fillBottom(Collections.singletonList(guiItem));
    }

    public void fillBottom(@NotNull List<GuiItem> list2) {
        int n = this.gui.getRows();
        List<GuiItem> list3 = this.repeatList(list2);
        for (int i = 9; i > 0; --i) {
            if (this.gui.getGuiItems().get(n * 9 - i) != null) continue;
            this.gui.setItem(n * 9 - i, list3.get(i));
        }
    }

    public void fillBorder(@NotNull GuiItem guiItem) {
        this.fillBorder(Collections.singletonList(guiItem));
    }

    public void fillBorder(@NotNull List<GuiItem> list2) {
        int n = this.gui.getRows();
        if (n <= 2) {
            return;
        }
        List<GuiItem> list3 = this.repeatList(list2);
        for (int i = 0; i < n * 9; ++i) {
            if (i > 8 && (i < n * 9 - 8 || i > n * 9 - 2) && i % 9 != 0 && i % 9 != 8) continue;
            this.gui.setItem(i, list3.get(i));
        }
    }

    public void fillBetweenPoints(int n, int n2, int n3, int n4, @NotNull GuiItem guiItem) {
        this.fillBetweenPoints(n, n2, n3, n4, Collections.singletonList(guiItem));
    }

    public void fillBetweenPoints(int n, int n2, int n3, int n4, @NotNull List<GuiItem> list2) {
        int n5 = Math.min(n, n3);
        int n6 = Math.max(n, n3);
        int n7 = Math.min(n2, n4);
        int n8 = Math.max(n2, n4);
        int n9 = this.gui.getRows();
        List<GuiItem> list3 = this.repeatList(list2);
        for (int i = 1; i <= n9; ++i) {
            for (int j = 1; j <= 9; ++j) {
                int n10 = this.getSlotFromRowCol(i, j);
                if (i < n5 || i > n6 || j < n7 || j > n8) continue;
                this.gui.setItem(n10, list3.get(n10));
            }
        }
    }

    public void fill(@NotNull GuiItem guiItem) {
        this.fill(Collections.singletonList(guiItem));
    }

    public void fill(@NotNull List<GuiItem> list2) {
        if (this.gui instanceof PaginatedGui) {
            throw new GuiException("Full filling a GUI is not supported in a Paginated GUI!");
        }
        GuiType guiType = this.gui.guiType();
        int n = guiType == GuiType.CHEST ? this.gui.getRows() * guiType.getLimit() : guiType.getLimit();
        List<GuiItem> list3 = this.repeatList(list2);
        for (int i = 0; i < n; ++i) {
            if (this.gui.getGuiItems().get(i) != null) continue;
            this.gui.setItem(i, list3.get(i));
        }
    }

    private List<GuiItem> repeatList(@NotNull List<GuiItem> list2) {
        ArrayList<GuiItem> arrayList = new ArrayList<GuiItem>();
        Collections.nCopies(this.gui.getRows() * 9, list2).forEach(arrayList::addAll);
        return arrayList;
    }

    private int getSlotFromRowCol(int n, int n2) {
        return n2 + (n - 1) * 9 - 1;
    }
}

