/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.gui.guis;

import java.util.UUID;
import me.glaremasters.guilds.libs.gui.components.GuiAction;
import me.glaremasters.guilds.libs.gui.components.util.ItemNbt;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiItem {
    private GuiAction<InventoryClickEvent> action;
    private ItemStack itemStack;
    private final UUID uuid = UUID.randomUUID();

    public GuiItem(@NotNull ItemStack itemStack, @Nullable GuiAction<@NotNull InventoryClickEvent> guiAction) {
        Validate.notNull((Object)itemStack, (String)"The ItemStack for the GUI Item cannot be null!");
        this.action = guiAction;
        this.itemStack = ItemNbt.setString(itemStack, "mf-gui", this.uuid.toString());
    }

    public GuiItem(@NotNull ItemStack itemStack) {
        this(itemStack, null);
    }

    public GuiItem(@NotNull Material material) {
        this(new ItemStack(material), null);
    }

    public GuiItem(@NotNull Material material, @Nullable GuiAction<@NotNull InventoryClickEvent> guiAction) {
        this(new ItemStack(material), guiAction);
    }

    public void setItemStack(@NotNull ItemStack itemStack) {
        Validate.notNull((Object)itemStack, (String)"The ItemStack for the GUI Item cannot be null!");
        this.itemStack = ItemNbt.setString(itemStack, "mf-gui", this.uuid.toString());
    }

    public void setAction(@Nullable GuiAction<@NotNull InventoryClickEvent> guiAction) {
        this.action = guiAction;
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @NotNull
    UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    GuiAction<InventoryClickEvent> getAction() {
        return this.action;
    }
}

