/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import me.glaremasters.guilds.libs.jdbi.v3.core.CloseException;
import me.glaremasters.guilds.libs.jdbi.v3.core.ConstantHandleSupplier;
import me.glaremasters.guilds.libs.jdbi.v3.core.HandleCallback;
import me.glaremasters.guilds.libs.jdbi.v3.core.HandleConsumer;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handles;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.Configurable;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.ExtensionMethod;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.Extensions;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.NoSuchExtensionException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Batch;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Call;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.PreparedBatch;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Query;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Script;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementBuilder;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Update;
import me.glaremasters.guilds.libs.jdbi.v3.core.transaction.TransactionException;
import me.glaremasters.guilds.libs.jdbi.v3.core.transaction.TransactionHandler;
import me.glaremasters.guilds.libs.jdbi.v3.core.transaction.TransactionIsolationLevel;
import me.glaremasters.guilds.libs.jdbi.v3.core.transaction.UnableToManipulateTransactionIsolationLevelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handle
implements Closeable,
Configurable<Handle> {
    private static final Logger LOG = LoggerFactory.getLogger(Handle.class);
    private final ConnectionCloser closer;
    private final TransactionHandler transactions;
    private final Connection connection;
    private final boolean forceEndTransactions;
    private ThreadLocal<ConfigRegistry> config;
    private ThreadLocal<ExtensionMethod> extensionMethod;
    private StatementBuilder statementBuilder;
    private boolean closed = false;

    Handle(ConfigRegistry configRegistry, ConnectionCloser connectionCloser, TransactionHandler transactionHandler, StatementBuilder statementBuilder, Connection connection) {
        this.closer = connectionCloser;
        this.transactions = transactionHandler;
        this.connection = connection;
        this.config = ThreadLocal.withInitial(() -> configRegistry);
        this.extensionMethod = new ThreadLocal();
        this.statementBuilder = statementBuilder;
        this.forceEndTransactions = !transactionHandler.isInTransaction(this);
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.config.get();
    }

    void setConfig(ConfigRegistry configRegistry) {
        this.config.set(configRegistry);
    }

    void setConfigThreadLocal(ThreadLocal<ConfigRegistry> threadLocal) {
        this.config = threadLocal;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public StatementBuilder getStatementBuilder() {
        return this.statementBuilder;
    }

    public Handle setStatementBuilder(StatementBuilder statementBuilder) {
        this.statementBuilder = statementBuilder;
        return this;
    }

    @Override
    public void close() {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        if (this.closed) {
            return;
        }
        boolean bl = false;
        if (this.forceEndTransactions && this.config.get().get(Handles.class).isForceEndTransactions()) {
            try {
                bl = this.isInTransaction();
            }
            catch (Exception exception) {
                arrayList.add(exception);
            }
        }
        this.extensionMethod.remove();
        this.config.remove();
        if (bl) {
            try {
                this.rollback();
            }
            catch (Exception exception) {
                arrayList.add(exception);
            }
        }
        try {
            this.statementBuilder.close(this.getConnection());
        }
        catch (Exception exception) {
            arrayList.add(exception);
        }
        try {
            this.closer.close(this.connection);
            if (!arrayList.isEmpty()) {
                Throwable throwable = (Throwable)arrayList.remove(0);
                arrayList.forEach(throwable::addSuppressed);
                throw new CloseException("Failed to clear transaction status on close", throwable);
            }
            if (bl) {
                throw new TransactionException("Improper transaction handling detected: A Handle with an open transaction was closed. Transactions must be explicitly committed or rolled back before closing the Handle. Jdbi has rolled back this transaction automatically. This check may be disabled by calling getConfig(Handles.class).setForceEndTransactions(false).");
            }
        }
        catch (SQLException sQLException) {
            CloseException closeException = new CloseException("Unable to close Connection", sQLException);
            arrayList.forEach(closeException::addSuppressed);
            throw closeException;
        }
        finally {
            LOG.trace("Handle [{}] released", (Object)this);
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Query select(String string, Object ... objectArray) {
        Query query = this.createQuery(string);
        int n = 0;
        for (Object object : objectArray) {
            query.bind(n++, object);
        }
        return query;
    }

    public int execute(String string, Object ... objectArray) {
        Update update = this.createUpdate(string);
        int n = 0;
        for (Object object : objectArray) {
            update.bind(n++, object);
        }
        return update.execute();
    }

    public Batch createBatch() {
        return new Batch(this);
    }

    public PreparedBatch prepareBatch(String string) {
        return new PreparedBatch(this, string);
    }

    public Call createCall(String string) {
        return new Call(this, string);
    }

    public Query createQuery(String string) {
        return new Query(this, string);
    }

    public Script createScript(String string) {
        return new Script(this, string);
    }

    public Update createUpdate(String string) {
        return new Update(this, string);
    }

    public boolean isInTransaction() {
        return this.transactions.isInTransaction(this);
    }

    public Handle begin() {
        this.transactions.begin(this);
        LOG.trace("Handle [{}] begin transaction", (Object)this);
        return this;
    }

    public Handle commit() {
        long l = System.nanoTime();
        this.transactions.commit(this);
        LOG.trace("Handle [{}] commit transaction in {}ms", (Object)this, (Object)Handle.msSince(l));
        return this;
    }

    public Handle rollback() {
        long l = System.nanoTime();
        this.transactions.rollback(this);
        LOG.trace("Handle [{}] rollback transaction in {}ms", (Object)this, (Object)Handle.msSince(l));
        return this;
    }

    public Handle rollbackToSavepoint(String string) {
        long l = System.nanoTime();
        this.transactions.rollbackToSavepoint(this, string);
        LOG.trace("Handle [{}] rollback to savepoint \"{}\" in {}ms", this, string, Handle.msSince(l));
        return this;
    }

    private static long msSince(long l) {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime() - l, TimeUnit.NANOSECONDS);
    }

    public Handle savepoint(String string) {
        this.transactions.savepoint(this, string);
        LOG.trace("Handle [{}] savepoint \"{}\"", (Object)this, (Object)string);
        return this;
    }

    public Handle release(String string) {
        this.transactions.releaseSavepoint(this, string);
        LOG.trace("Handle [{}] release savepoint \"{}\"", (Object)this, (Object)string);
        return this;
    }

    public boolean isReadOnly() {
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException sQLException) {
            throw new UnableToManipulateTransactionIsolationLevelException("Could not getReadOnly", sQLException);
        }
    }

    public Handle setReadOnly(boolean bl) {
        try {
            this.connection.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            throw new UnableToManipulateTransactionIsolationLevelException("Could not setReadOnly", sQLException);
        }
        return this;
    }

    public <R, X extends Exception> R inTransaction(HandleCallback<R, X> handleCallback) {
        return this.isInTransaction() ? handleCallback.withHandle(this) : this.transactions.inTransaction(this, handleCallback);
    }

    public <X extends Exception> void useTransaction(HandleConsumer<X> handleConsumer) {
        this.inTransaction(handle -> {
            handleConsumer.useHandle(handle);
            return null;
        });
    }

    public <R, X extends Exception> R inTransaction(TransactionIsolationLevel transactionIsolationLevel, HandleCallback<R, X> handleCallback) {
        if (this.isInTransaction()) {
            TransactionIsolationLevel transactionIsolationLevel2 = this.getTransactionIsolationLevel();
            if (transactionIsolationLevel2 != transactionIsolationLevel && transactionIsolationLevel != TransactionIsolationLevel.UNKNOWN) {
                throw new TransactionException("Tried to execute nested transaction with isolation level " + (Object)((Object)transactionIsolationLevel) + ", but already running in a transaction with isolation level " + (Object)((Object)transactionIsolationLevel2) + ".");
            }
            return handleCallback.withHandle(this);
        }
        try (TransactionResetter transactionResetter = new TransactionResetter(this.getTransactionIsolationLevel());){
            this.setTransactionIsolation(transactionIsolationLevel);
            R r = this.transactions.inTransaction(this, transactionIsolationLevel, handleCallback);
            return r;
        }
    }

    public <X extends Exception> void useTransaction(TransactionIsolationLevel transactionIsolationLevel, HandleConsumer<X> handleConsumer) {
        this.inTransaction(transactionIsolationLevel, handle -> {
            handleConsumer.useHandle(handle);
            return null;
        });
    }

    public void setTransactionIsolation(TransactionIsolationLevel transactionIsolationLevel) {
        if (transactionIsolationLevel != TransactionIsolationLevel.UNKNOWN) {
            this.setTransactionIsolation(transactionIsolationLevel.intValue());
        }
    }

    public void setTransactionIsolation(int n) {
        try {
            if (this.connection.getTransactionIsolation() != n) {
                this.connection.setTransactionIsolation(n);
            }
        }
        catch (SQLException sQLException) {
            throw new UnableToManipulateTransactionIsolationLevelException(n, sQLException);
        }
    }

    public TransactionIsolationLevel getTransactionIsolationLevel() {
        try {
            return TransactionIsolationLevel.valueOf(this.connection.getTransactionIsolation());
        }
        catch (SQLException sQLException) {
            throw new UnableToManipulateTransactionIsolationLevelException("unable to access current setting", sQLException);
        }
    }

    public <T> T attach(Class<T> clazz) {
        return this.getConfig(Extensions.class).findFor(clazz, ConstantHandleSupplier.of(this)).orElseThrow(() -> new NoSuchExtensionException("Extension not found: " + clazz));
    }

    public ExtensionMethod getExtensionMethod() {
        return this.extensionMethod.get();
    }

    void setExtensionMethod(ExtensionMethod extensionMethod) {
        this.extensionMethod.set(extensionMethod);
    }

    void setExtensionMethodThreadLocal(ThreadLocal<ExtensionMethod> threadLocal) {
        this.extensionMethod = Objects.requireNonNull(threadLocal);
    }

    private class TransactionResetter
    implements Closeable {
        private final TransactionIsolationLevel initial;

        TransactionResetter(TransactionIsolationLevel transactionIsolationLevel) {
            this.initial = transactionIsolationLevel;
        }

        @Override
        public void close() {
            Handle.this.setTransactionIsolation(this.initial);
        }
    }

    static interface ConnectionCloser {
        public void close(Connection var1) throws SQLException;
    }
}

