/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core;

import java.util.concurrent.Callable;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.Jdbi;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.ExtensionMethod;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.HandleSupplier;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.JdbiThreadLocals;

class LazyHandleSupplier
implements HandleSupplier,
AutoCloseable {
    private final Object[] lock = new Object[0];
    private final Jdbi db;
    private final ThreadLocal<ConfigRegistry> config;
    private final ThreadLocal<ExtensionMethod> extensionMethod = new ThreadLocal();
    private volatile Handle handle;
    private volatile boolean closed = false;

    LazyHandleSupplier(Jdbi jdbi, ConfigRegistry configRegistry) {
        this.db = jdbi;
        this.config = ThreadLocal.withInitial(() -> configRegistry);
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.config.get();
    }

    @Override
    public Handle getHandle() {
        if (this.handle == null) {
            this.initHandle();
        }
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHandle() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            if (this.handle == null) {
                if (this.closed) {
                    throw new IllegalStateException("Handle is closed");
                }
                Handle handle = this.db.open();
                handle.setExtensionMethodThreadLocal(this.extensionMethod);
                handle.setConfigThreadLocal(this.config);
                this.handle = handle;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public <V> V invokeInContext(ExtensionMethod extensionMethod, ConfigRegistry configRegistry, Callable<V> callable) {
        return (V)JdbiThreadLocals.invokeInContext(this.extensionMethod, extensionMethod, () -> JdbiThreadLocals.invokeInContext(this.config, configRegistry, callable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.closed = true;
            if (this.handle == null) {
                this.config.remove();
                this.extensionMethod.remove();
            } else {
                this.handle.close();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

