/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import me.glaremasters.guilds.libs.jdbi.v3.core.Jdbi;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.UtilityClassException;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.Unchecked;

class OnDemandExtensions {
    private static final Method EQUALS_METHOD;
    private static final Method HASHCODE_METHOD;
    private static final Method TOSTRING_METHOD;

    private OnDemandExtensions() {
        throw new UtilityClassException();
    }

    static <E> E create(Jdbi jdbi, Class<E> clazz) {
        InvocationHandler invocationHandler = (object2, method, objectArray) -> {
            if (EQUALS_METHOD.equals(method)) {
                return object2 == objectArray[0];
            }
            if (HASHCODE_METHOD.equals(method)) {
                return System.identityHashCode(object2);
            }
            if (TOSTRING_METHOD.equals(method)) {
                return clazz + "@" + Integer.toHexString(System.identityHashCode(object2));
            }
            return jdbi.withExtension(clazz, object -> OnDemandExtensions.invoke(object, method, objectArray));
        };
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler));
    }

    private static Object invoke(Object object, Method method, Object[] objectArray2) {
        if (Proxy.isProxyClass(object.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
            return Unchecked.function(objectArray -> invocationHandler.invoke(object, method, (Object[])objectArray)).apply(objectArray2);
        }
        MethodHandle methodHandle = Unchecked.function(MethodHandles.lookup()::unreflect).apply(method).bindTo(object);
        return Unchecked.function(methodHandle::invokeWithArguments).apply(objectArray2);
    }

    static {
        try {
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
            HASHCODE_METHOD = Object.class.getMethod("hashCode", new Class[0]);
            TOSTRING_METHOD = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("JVM error", noSuchMethodException);
        }
    }
}

