/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Arguments;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NullArgument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.QualifiedArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.enums.EnumStrategy;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.EnumStrategies;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;

class EnumArgumentFactory
implements QualifiedArgumentFactory {
    EnumArgumentFactory() {
    }

    @Override
    public Optional<Argument> build(QualifiedType<?> qualifiedType, Object object, ConfigRegistry configRegistry) {
        return EnumArgumentFactory.ifEnum(qualifiedType.getType()).flatMap(clazz -> EnumArgumentFactory.makeEnumArgument(qualifiedType, (Enum)object, configRegistry));
    }

    static <E extends Enum<E>> Optional<Class<E>> ifEnum(Type type) {
        return Optional.of(type).map(GenericTypes::getErasedType).filter(Class::isEnum).map(clazz -> clazz);
    }

    private static <E extends Enum<E>> Optional<Argument> makeEnumArgument(QualifiedType<E> qualifiedType, E e, ConfigRegistry configRegistry) {
        boolean bl = EnumStrategy.BY_NAME == configRegistry.get(EnumStrategies.class).findStrategy(qualifiedType);
        return bl ? EnumArgumentFactory.byName(e, configRegistry) : EnumArgumentFactory.byOrdinal(e, configRegistry);
    }

    private static <E extends Enum<E>> Optional<Argument> byName(E e, ConfigRegistry configRegistry) {
        return EnumArgumentFactory.makeArgument(12, String.class, e, Enum::name, configRegistry);
    }

    private static <E extends Enum<E>> Optional<Argument> byOrdinal(E e, ConfigRegistry configRegistry) {
        return EnumArgumentFactory.makeArgument(4, Integer.class, e, Enum::ordinal, configRegistry);
    }

    private static <A, E extends Enum<E>> Optional<Argument> makeArgument(int n, Class<A> clazz, E e, Function<E, A> function, ConfigRegistry configRegistry) {
        if (e == null) {
            return Optional.of(new NullArgument(n));
        }
        return configRegistry.get(Arguments.class).findFor(clazz, function.apply(e));
    }
}

