/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal.strategies;

import java.sql.PreparedStatement;
import java.util.Objects;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal.StatementBinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

public class LoggableBinderArgument<T>
implements Argument {
    private final T value;
    private final StatementBinder<T> binder;

    public static Argument bindAsString(Object object) {
        return new LoggableBinderArgument<String>(Objects.toString(object, null), PreparedStatement::setString);
    }

    public LoggableBinderArgument(T t, StatementBinder<T> statementBinder) {
        this.value = t;
        this.binder = statementBinder;
    }

    @Override
    public void apply(int n, PreparedStatement preparedStatement, StatementContext statementContext) {
        this.binder.bind(preparedStatement, n, this.value);
    }

    public String toString() {
        return Objects.toString(this.value);
    }
}

