/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.array;

import java.sql.Array;
import java.sql.ResultSet;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

class CollectorColumnMapper<T, A, R>
implements ColumnMapper<R> {
    private final ColumnMapper<T> elementMapper;
    private final Collector<T, A, R> collector;

    CollectorColumnMapper(ColumnMapper<T> columnMapper, Collector<T, A, R> collector) {
        this.elementMapper = columnMapper;
        this.collector = collector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R map(ResultSet resultSet, int n, StatementContext statementContext) {
        Array array = resultSet.getArray(n);
        if (array == null) {
            return null;
        }
        try {
            R r = this.buildFromResultSet(array, statementContext);
            return r;
        }
        finally {
            array.free();
        }
    }

    private R buildFromResultSet(Array array, StatementContext statementContext) {
        A a = this.collector.supplier().get();
        BiConsumer<A, A> biConsumer = this.collector.accumulator();
        try (ResultSet resultSet = array.getResultSet();){
            while (resultSet.next()) {
                biConsumer.accept(a, this.elementMapper.map(resultSet, 2, statementContext));
            }
        }
        return this.collector.finisher().apply(a);
    }
}

