/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.array;

import java.lang.reflect.Type;
import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayType;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayTypeFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;

class InferredSqlArrayTypeFactory
implements SqlArrayTypeFactory {
    private final Type elementType;
    private final SqlArrayType<?> arrayType;

    InferredSqlArrayTypeFactory(SqlArrayType<?> sqlArrayType) {
        this.elementType = GenericTypes.findGenericParameter(sqlArrayType.getClass(), SqlArrayType.class).orElseThrow(() -> new UnsupportedOperationException("Must use a concretely typed SqlArrayType here"));
        this.arrayType = sqlArrayType;
    }

    @Override
    public Optional<SqlArrayType<?>> build(Type type, ConfigRegistry configRegistry) {
        return this.elementType.equals(type) ? Optional.of(this.arrayType) : Optional.empty();
    }
}

