/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.enums.internal;

import java.lang.reflect.Type;
import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayType;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayTypeFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.enums.EnumStrategy;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.EnumStrategies;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;

public class EnumSqlArrayTypeFactory
implements SqlArrayTypeFactory {
    @Override
    public Optional<SqlArrayType<?>> build(Type type, ConfigRegistry configRegistry) {
        return Optional.of(type).map(GenericTypes::getErasedType).filter(Class::isEnum).map(clazz -> this.makeSqlArrayType((Class)clazz, configRegistry));
    }

    private <E extends Enum<E>> SqlArrayType<E> makeSqlArrayType(Class<E> clazz, ConfigRegistry configRegistry) {
        boolean bl = EnumStrategy.BY_NAME == configRegistry.get(EnumStrategies.class).findStrategy(QualifiedType.of(clazz));
        return bl ? SqlArrayType.of("varchar", Enum::name) : SqlArrayType.of("integer", Enum::ordinal);
    }
}

