/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.GetterMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

class EssentialsMapperFactory
implements ColumnMapperFactory {
    private final Map<Class<?>, ColumnMapper<?>> mappers = new IdentityHashMap();

    EssentialsMapperFactory() {
        this.mappers.put(BigDecimal.class, new GetterMapper<BigDecimal>(ResultSet::getBigDecimal));
        this.mappers.put(String.class, new GetterMapper<String>(ResultSet::getString));
        this.mappers.put(byte[].class, new GetterMapper<byte[]>(ResultSet::getBytes));
        this.mappers.put(UUID.class, EssentialsMapperFactory::getUUID);
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry configRegistry) {
        Class<?> clazz = GenericTypes.getErasedType(type);
        return Optional.ofNullable(this.mappers.get(clazz));
    }

    private static UUID getUUID(ResultSet resultSet, int n, StatementContext statementContext) {
        String string = resultSet.getString(n);
        return string == null ? null : UUID.fromString(string);
    }
}

