/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.GetterMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.MappingException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

class InternetMapperFactory
implements ColumnMapperFactory {
    private final Map<Class<?>, ColumnMapper<?>> mappers = new IdentityHashMap();

    InternetMapperFactory() {
        this.mappers.put(InetAddress.class, InternetMapperFactory::getInetAddress);
        this.mappers.put(URL.class, new GetterMapper<URL>(ResultSet::getURL));
        this.mappers.put(URI.class, new GetterMapper<URI>(InternetMapperFactory::getURI));
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry configRegistry) {
        Class<?> clazz = GenericTypes.getErasedType(type);
        return Optional.ofNullable(this.mappers.get(clazz));
    }

    private static URI getURI(ResultSet resultSet, int n) {
        String string = resultSet.getString(n);
        try {
            return string == null ? null : new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SQLException("Failed to convert data to URI", uRISyntaxException);
        }
    }

    private static InetAddress getInetAddress(ResultSet resultSet, int n, StatementContext statementContext) {
        String string = resultSet.getString(n);
        try {
            return string == null ? null : InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new MappingException("Could not map InetAddress", unknownHostException);
        }
    }
}

