/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.GetterMapper;

class JavaTimeMapperFactory
implements ColumnMapperFactory {
    private final Map<Class<?>, ColumnMapper<?>> mappers = new IdentityHashMap();

    JavaTimeMapperFactory() {
        this.mappers.put(Instant.class, new GetterMapper<Instant>(JavaTimeMapperFactory::getInstant));
        this.mappers.put(LocalDate.class, new GetterMapper<LocalDate>(JavaTimeMapperFactory::getLocalDate));
        this.mappers.put(LocalTime.class, new GetterMapper<LocalTime>(JavaTimeMapperFactory::getLocalTime));
        this.mappers.put(LocalDateTime.class, new GetterMapper<LocalDateTime>(JavaTimeMapperFactory::getLocalDateTime));
        this.mappers.put(OffsetDateTime.class, new GetterMapper<OffsetDateTime>(JavaTimeMapperFactory::getOffsetDateTime));
        this.mappers.put(ZonedDateTime.class, new GetterMapper<ZonedDateTime>(JavaTimeMapperFactory::getZonedDateTime));
        this.mappers.put(ZoneId.class, new GetterMapper<ZoneId>(JavaTimeMapperFactory::getZoneId));
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry configRegistry) {
        Class<?> clazz = GenericTypes.getErasedType(type);
        return Optional.ofNullable(this.mappers.get(clazz));
    }

    private static Instant getInstant(ResultSet resultSet, int n) {
        Timestamp timestamp = resultSet.getTimestamp(n);
        return timestamp == null ? null : timestamp.toInstant();
    }

    private static LocalDate getLocalDate(ResultSet resultSet, int n) {
        Timestamp timestamp = resultSet.getTimestamp(n);
        return timestamp == null ? null : timestamp.toLocalDateTime().toLocalDate();
    }

    private static LocalDateTime getLocalDateTime(ResultSet resultSet, int n) {
        Timestamp timestamp = resultSet.getTimestamp(n);
        return timestamp == null ? null : timestamp.toLocalDateTime();
    }

    private static OffsetDateTime getOffsetDateTime(ResultSet resultSet, int n) {
        Timestamp timestamp = resultSet.getTimestamp(n);
        return timestamp == null ? null : OffsetDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault());
    }

    private static ZonedDateTime getZonedDateTime(ResultSet resultSet, int n) {
        Timestamp timestamp = resultSet.getTimestamp(n);
        return timestamp == null ? null : ZonedDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault());
    }

    private static LocalTime getLocalTime(ResultSet resultSet, int n) {
        Time time = resultSet.getTime(n);
        return time == null ? null : time.toLocalTime();
    }

    private static ZoneId getZoneId(ResultSet resultSet, int n) {
        String string = resultSet.getString(n);
        return string == null ? null : ZoneId.of(string);
    }
}

