/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericType;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMappers;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMappers;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.SingleColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.meta.Beta;

public class Mappers
implements JdbiConfig<Mappers> {
    private RowMappers rowMappers;
    private ColumnMappers columnMappers;

    @Override
    public void setRegistry(ConfigRegistry configRegistry) {
        this.rowMappers = configRegistry.get(RowMappers.class);
        this.columnMappers = configRegistry.get(ColumnMappers.class);
    }

    public <T> Optional<RowMapper<T>> findFor(Class<T> clazz) {
        RowMapper rowMapper = this.findFor((Type)clazz).orElse(null);
        return Optional.ofNullable(rowMapper);
    }

    public <T> Optional<RowMapper<T>> findFor(GenericType<T> genericType) {
        RowMapper rowMapper = this.findFor(genericType.getType()).orElse(null);
        return Optional.ofNullable(rowMapper);
    }

    public Optional<RowMapper<?>> findFor(Type type) {
        return this.findFor(QualifiedType.of(type)).map(rowMapper -> rowMapper);
    }

    @Beta
    public <T> Optional<RowMapper<T>> findFor(QualifiedType<T> qualifiedType) {
        Optional<RowMapper<T>> optional;
        if (qualifiedType.getQualifiers().isEmpty() && (optional = this.rowMappers.findFor(qualifiedType.getType()).map(rowMapper -> rowMapper)).isPresent()) {
            return optional;
        }
        return this.columnMappers.findFor(qualifiedType).map(SingleColumnMapper::new);
    }

    @Override
    public Mappers createCopy() {
        return new Mappers();
    }
}

