/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnGetter;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapperFactory;

class PrimitiveMapperFactory
implements ColumnMapperFactory {
    private final Map<Class<?>, ColumnMapper<?>> mappers = new IdentityHashMap();

    PrimitiveMapperFactory() {
        this.mappers.put(Boolean.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getBoolean));
        this.mappers.put(Byte.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getByte));
        this.mappers.put(Character.TYPE, PrimitiveMapperFactory.primitiveMapper(PrimitiveMapperFactory::getChar));
        this.mappers.put(Short.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getShort));
        this.mappers.put(Integer.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getInt));
        this.mappers.put(Long.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getLong));
        this.mappers.put(Float.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getFloat));
        this.mappers.put(Double.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getDouble));
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry configRegistry) {
        Class<?> clazz = GenericTypes.getErasedType(type);
        return Optional.ofNullable(this.mappers.get(clazz));
    }

    private static <T> ColumnMapper<T> primitiveMapper(ColumnGetter<T> columnGetter) {
        return (resultSet, n, statementContext) -> columnGetter.get(resultSet, n);
    }

    private static char getChar(ResultSet resultSet, int n) {
        Character c = PrimitiveMapperFactory.getCharacter(resultSet, n);
        return c == null ? (char)'\u0000' : c.charValue();
    }

    private static Character getCharacter(ResultSet resultSet, int n) {
        String string = resultSet.getString(n);
        if (string != null && !string.isEmpty()) {
            return Character.valueOf(string.charAt(0));
        }
        return null;
    }
}

