/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.internal;

import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCache;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCaches;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.CheckedBiFunction;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.CheckedFunction;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.Unchecked;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.Qualifiers;

public interface ImmutablesPropertiesFactory {
    public static final JdbiCache<ImmutableSpec<?, ?>, ImmutablePojoProperties<?, ?>> IMMUTABLE_CACHE = JdbiCaches.declare(s -> s.type, ImmutablePojoProperties::new);
    public static final JdbiCache<ModifiableSpec<?, ?>, ModifiablePojoProperties<?, ?>> MODIFIABLE_CACHE = JdbiCaches.declare(s -> s.type, ModifiablePojoProperties::new);

    public PojoProperties<?> create(Type var1, ConfigRegistry var2);

    public static <T, B> ImmutablesPropertiesFactory immutable(Class<T> defn, Supplier<B> builder) {
        return (t, config) -> IMMUTABLE_CACHE.get(new ImmutableSpec(t, config, defn, builder), config);
    }

    public static <T, M extends T> ImmutablesPropertiesFactory modifiable(Class<T> defn, Class<M> impl, Supplier<M> constructor) {
        return (t, config) -> MODIFIABLE_CACHE.get(new ModifiableSpec(t, config, defn, impl, constructor), config);
    }

    public static MethodHandle alwaysSet() {
        return MethodHandles.dropArguments(MethodHandles.constant(Boolean.TYPE, true), 0, new Class[]{Object.class});
    }

    public static class ModifiableSpec<T, M> {
        Type type;
        ConfigRegistry config;
        Class<T> defn;
        Class<M> impl;
        Supplier<M> constructor;

        ModifiableSpec(Type type, ConfigRegistry configRegistry, Class<T> clazz, Class<M> clazz2, Supplier<M> supplier) {
            this.type = type;
            this.config = configRegistry;
            this.defn = clazz;
            this.impl = clazz2;
            this.constructor = supplier;
        }
    }

    public static class ImmutableSpec<T, B> {
        Type type;
        ConfigRegistry config;
        Class<T> defn;
        Supplier<B> builder;

        ImmutableSpec(Type type, ConfigRegistry configRegistry, Class<T> clazz, Supplier<B> supplier) {
            this.type = type;
            this.config = configRegistry;
            this.defn = clazz;
            this.builder = supplier;
        }
    }

    public static class ImmutablesPojoProperty<T>
    implements PojoProperties.PojoProperty<T> {
        private final String name;
        private final QualifiedType<?> type;
        private final Method defn;
        private final MethodHandle isSet;
        private final MethodHandle getter;
        final MethodHandle setter;

        ImmutablesPojoProperty(String string, QualifiedType<?> qualifiedType, Method method, MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
            this.name = string;
            this.type = qualifiedType;
            this.defn = method;
            this.isSet = methodHandle;
            this.getter = methodHandle2;
            this.setter = methodHandle3;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public QualifiedType<?> getQualifiedType() {
            return this.type;
        }

        @Override
        public <A extends Annotation> Optional<A> getAnnotation(Class<A> clazz) {
            return Optional.ofNullable(this.defn.getAnnotation(clazz));
        }

        @Override
        public Object get(T t) {
            return Unchecked.callable(() -> {
                if (Boolean.TRUE.equals(this.isSet.invoke(t))) {
                    return this.getter.invoke(t);
                }
                return null;
            }).call();
        }
    }

    public static class ModifiablePojoProperties<T, M>
    extends BasePojoProperties<T, M> {
        ModifiablePojoProperties(ModifiableSpec<T, M> modifiableSpec) {
            super(modifiableSpec.type, modifiableSpec.config, modifiableSpec.defn, modifiableSpec.impl, modifiableSpec.constructor);
        }

        @Override
        protected ImmutablesPojoProperty<T> createProperty(String string, Method method) {
            Type type = GenericTypes.resolveType(method.getGenericReturnType(), this.getType());
            try {
                return new ImmutablesPojoProperty(string, QualifiedType.of(type).withAnnotations(this.config.get(Qualifiers.class).findFor(method)), method, this.isSetMethod(string), MethodHandles.lookup().unreflect(method).asFixedArity(), MethodHandles.lookup().findVirtual(this.impl, this.setterName(string), MethodType.methodType(this.impl, GenericTypes.getErasedType(type))).asFixedArity());
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new IllegalArgumentException("Failed to inspect method " + method, reflectiveOperationException);
            }
        }

        private MethodHandle isSetMethod(String string) {
            try {
                return MethodHandles.lookup().findVirtual(this.impl, string + "IsSet", MethodType.methodType(Boolean.TYPE));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return ImmutablesPropertiesFactory.alwaysSet();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("Failed to find IsSet method for " + string, illegalAccessException);
            }
        }

        private String setterName(String string) {
            return "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
        }

        @Override
        public PojoProperties.PojoBuilder<T> create() {
            final Object t = this.builder.get();
            return new PojoProperties.PojoBuilder<T>(){

                @Override
                public void set(String string, Object object) {
                    Unchecked.biFunction((CheckedBiFunction<Object, Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)this.getProperties().get((Object)string).setter)).apply(t, object);
                }

                @Override
                public T build() {
                    return t;
                }
            };
        }
    }

    public static class ImmutablePojoProperties<T, B>
    extends BasePojoProperties<T, B> {
        private MethodHandle builderBuild;

        ImmutablePojoProperties(ImmutableSpec<T, B> immutableSpec) {
            super(immutableSpec.type, immutableSpec.config, immutableSpec.defn, null, immutableSpec.builder);
            try {
                this.builderBuild = MethodHandles.lookup().unreflect(this.builder.get().getClass().getMethod("build", new Class[0]));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new IllegalArgumentException("Failed to inspect Immutables " + this.defn, reflectiveOperationException);
            }
        }

        @Override
        protected ImmutablesPojoProperty<T> createProperty(String string, Method method) {
            Class<?> clazz = this.builder.get().getClass();
            try {
                Type type = GenericTypes.resolveType(method.getGenericReturnType(), this.getType());
                return new ImmutablesPojoProperty(string, QualifiedType.of(type).withAnnotations(this.config.get(Qualifiers.class).findFor(method)), method, ImmutablesPropertiesFactory.alwaysSet(), MethodHandles.lookup().unreflect(method).asFixedArity(), this.findBuilderSetter(clazz, string, type).asFixedArity());
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new IllegalArgumentException("Failed to inspect method " + method, reflectiveOperationException);
            }
        }

        private MethodHandle findBuilderSetter(Class<?> clazz, String string, Type type) {
            ArrayList<NoSuchMethodException> arrayList = new ArrayList<NoSuchMethodException>();
            String string2 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(string2, string));
            for (String string3 : hashSet) {
                try {
                    return MethodHandles.lookup().unreflect(clazz.getMethod(string3, GenericTypes.getErasedType(type)));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    arrayList.add(noSuchMethodException);
                }
            }
            for (Method method : clazz.getMethods()) {
                if (!hashSet.contains(method.getName()) || method.getParameterCount() != 1) continue;
                return MethodHandles.lookup().unreflect(method);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Failed to find builder setter for property " + string + " on " + clazz);
            arrayList.forEach(illegalArgumentException::addSuppressed);
            return MethodHandles.dropArguments(MethodHandles.throwException(Object.class, IllegalArgumentException.class), 1, Arrays.asList(Object.class, Object.class)).bindTo(illegalArgumentException);
        }

        @Override
        public PojoProperties.PojoBuilder<T> create() {
            final Object t = this.builder.get();
            return new PojoProperties.PojoBuilder<T>(){

                @Override
                public void set(String string, Object object) {
                    Unchecked.biFunction((CheckedBiFunction<Object, Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)this.getProperties().get((Object)string).setter)).apply(t, object);
                }

                @Override
                public T build() {
                    return defn.cast(Unchecked.function((CheckedFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)builderBuild)).apply(t));
                }
            };
        }
    }

    public static abstract class BasePojoProperties<T, B>
    extends PojoProperties<T> {
        private final Map<String, ImmutablesPojoProperty<T>> properties;
        protected final ConfigRegistry config;
        protected final Class<T> defn;
        protected final Class<?> impl;
        protected final Supplier<?> builder;

        BasePojoProperties(Type type, ConfigRegistry configRegistry, Class<T> clazz, Class<?> clazz2, Supplier<B> supplier) {
            super(type);
            this.config = configRegistry;
            this.defn = clazz;
            this.impl = clazz2;
            this.builder = supplier;
            this.properties = Arrays.stream(clazz.getMethods()).filter(BasePojoProperties::isProperty).map(method -> this.createProperty(BasePojoProperties.propertyName(method), (Method)method)).collect(Collectors.toMap(PojoProperties.PojoProperty::getName, Function.identity()));
        }

        static String propertyName(Method method) {
            String[] stringArray = new String[]{"get", "is"};
            String string = method.getName();
            for (String string2 : stringArray) {
                if (!string.startsWith(string2)) continue;
                return BasePojoProperties.chopPrefix(string, string2.length());
            }
            return string;
        }

        private static String chopPrefix(String string, int n) {
            return string.substring(n, n + 1).toLowerCase() + string.substring(n + 1);
        }

        private static boolean isProperty(Method method) {
            return method.getParameterCount() == 0 && !method.isSynthetic() && !Modifier.isStatic(method.getModifiers()) && method.getDeclaringClass() != Object.class;
        }

        @Override
        public Map<String, ImmutablesPojoProperty<T>> getProperties() {
            return this.properties;
        }

        abstract ImmutablesPojoProperty<T> createProperty(String var1, Method var2);
    }
}

