/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.result;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Supplier;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.EmptyResultSet;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.NoResultsException;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultBearing;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultProducer;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultSetException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

public class ResultProducers
implements JdbiConfig<ResultProducers> {
    private boolean allowNoResults;

    public ResultProducers() {
        this(false);
    }

    private ResultProducers(boolean bl) {
        this.allowNoResults = bl;
    }

    public static ResultProducer<Integer> returningUpdateCount() {
        return (supplier, statementContext) -> {
            try (StatementContext statementContext2 = statementContext;){
                Integer n = ((PreparedStatement)supplier.get()).getUpdateCount();
                return n;
            }
        };
    }

    public static ResultProducer<ResultBearing> returningResults() {
        return (supplier, statementContext) -> ResultBearing.of(ResultProducers.getResultSet(supplier, statementContext), statementContext);
    }

    private static Supplier<ResultSet> getResultSet(Supplier<PreparedStatement> supplier, StatementContext statementContext) {
        return () -> {
            try {
                ResultSet resultSet = ((PreparedStatement)supplier.get()).getResultSet();
                if (resultSet == null) {
                    if (statementContext.getConfig(ResultProducers.class).allowNoResults) {
                        return new EmptyResultSet();
                    }
                    throw new NoResultsException("Statement returned no results", statementContext);
                }
                statementContext.addCleanable(resultSet::close);
                return resultSet;
            }
            catch (SQLException sQLException) {
                throw new ResultSetException("Could not get result set", sQLException, statementContext);
            }
        };
    }

    public static ResultProducer<ResultBearing> returningGeneratedKeys(String ... stringArray) {
        return (supplier, statementContext) -> {
            statementContext.setReturningGeneratedKeys(true);
            if (stringArray.length > 0) {
                statementContext.setGeneratedKeysColumnNames(stringArray);
            }
            return ResultBearing.of(ResultProducers.getGeneratedKeys(supplier, statementContext), statementContext);
        };
    }

    private static Supplier<ResultSet> getGeneratedKeys(Supplier<PreparedStatement> supplier, StatementContext statementContext) {
        return () -> {
            try {
                ResultSet resultSet = ((PreparedStatement)supplier.get()).getGeneratedKeys();
                if (resultSet == null) {
                    throw new NoResultsException("Statement returned no generated keys", statementContext);
                }
                statementContext.addCleanable(resultSet::close);
                return resultSet;
            }
            catch (SQLException sQLException) {
                throw new ResultSetException("Could not get generated keys", sQLException, statementContext);
            }
        };
    }

    @Override
    public ResultProducers createCopy() {
        return new ResultProducers(this.allowNoResults);
    }

    public ResultProducers allowNoResults(boolean bl) {
        this.allowNoResults = bl;
        return this;
    }
}

