/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.UtilityClassException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Binding;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.ParsedParameters;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlStatements;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToCreateStatementException;

class ArgumentBinder {
    private ArgumentBinder() {
        throw new UtilityClassException();
    }

    static void bind(ParsedParameters parsedParameters, Binding binding, PreparedStatement preparedStatement, StatementContext statementContext) {
        if (parsedParameters.isPositional()) {
            ArgumentBinder.bindPositional(parsedParameters, binding, preparedStatement, statementContext);
        } else {
            ArgumentBinder.bindNamed(parsedParameters, binding, preparedStatement, statementContext);
        }
    }

    private static void bindPositional(ParsedParameters parsedParameters, Binding binding, PreparedStatement preparedStatement, StatementContext statementContext) {
        boolean bl = binding.findForPosition(parsedParameters.getParameterCount()).isPresent();
        if (bl && !statementContext.getConfig(SqlStatements.class).isUnusedBindingAllowed()) {
            throw new UnableToCreateStatementException("Superfluous positional param at (0 based) position " + parsedParameters.getParameterCount(), statementContext);
        }
        for (int i = 0; i < parsedParameters.getParameterCount(); ++i) {
            int n = i;
            try {
                binding.findForPosition(i).orElseThrow(() -> new UnableToCreateStatementException("Missing positional param at (0 based) position " + n, statementContext)).apply(i + 1, preparedStatement, statementContext);
                continue;
            }
            catch (SQLException sQLException) {
                throw new UnableToCreateStatementException("Exception while binding positional param at (0 based) position " + i, sQLException, statementContext);
            }
        }
    }

    private static void bindNamed(ParsedParameters parsedParameters, Binding binding, PreparedStatement preparedStatement, StatementContext statementContext) {
        boolean bl;
        List<String> list2 = parsedParameters.getParameterNames();
        boolean bl2 = bl = list2.isEmpty() && !binding.isEmpty();
        if (bl && !statementContext.getConfig(SqlStatements.class).isUnusedBindingAllowed()) {
            throw new UnableToCreateStatementException(String.format("Superfluous named parameters provided while the query declares none: '%s'. This check may be disabled by calling getConfig(SqlStatements.class).setUnusedBindingAllowed(true) or using @AllowUnusedBindings in SQL object.", binding), statementContext);
        }
        for (int i = 0; i < list2.size(); ++i) {
            String string = list2.get(i);
            try {
                binding.findForName(string, statementContext).orElseThrow(() -> new UnableToCreateStatementException(String.format("Missing named parameter '%s'.", string), statementContext)).apply(i + 1, preparedStatement, statementContext);
                continue;
            }
            catch (SQLException sQLException) {
                throw new UnableToCreateStatementException(String.format("Exception while binding named parameter '%s'", string), sQLException, statementContext);
            }
        }
    }
}

