/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.Collection;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.Configurable;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Cleanable;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlStatements;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementCustomizer;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToExecuteStatementException;

abstract class BaseStatement<This>
implements Closeable,
Configurable<This> {
    final This typedThis = this;
    private final Handle handle;
    private final StatementContext ctx;

    BaseStatement(Handle handle) {
        this.handle = handle;
        this.ctx = new StatementContext(handle.getConfig().createCopy(), handle.getExtensionMethod());
        if (GenericTypes.findGenericParameter(this.getClass(), BaseStatement.class).map(GenericTypes::getErasedType).map(clazz -> !clazz.isAssignableFrom(this.getClass())).orElse(false).booleanValue()) {
            throw new IllegalStateException("inconsistent SqlStatement hierarchy");
        }
    }

    public Handle getHandle() {
        return this.handle;
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.ctx.getConfig();
    }

    public final StatementContext getContext() {
        return this.ctx;
    }

    This addCleanable(Cleanable cleanable) {
        this.getContext().addCleanable(cleanable);
        return this.typedThis;
    }

    void addCustomizers(Collection<StatementCustomizer> collection) {
        collection.forEach(this::addCustomizer);
    }

    final void callCustomizers(StatementCustomizerInvocation statementCustomizerInvocation) {
        for (StatementCustomizer statementCustomizer : this.getCustomizers()) {
            try {
                statementCustomizerInvocation.call(statementCustomizer);
            }
            catch (SQLException sQLException) {
                throw new UnableToExecuteStatementException("Exception thrown in statement customization", sQLException, this.ctx);
            }
        }
    }

    private Collection<StatementCustomizer> getCustomizers() {
        return this.getConfig(SqlStatements.class).getCustomizers();
    }

    @Override
    public void close() {
        this.getContext().close();
    }

    @FunctionalInterface
    static interface StatementCustomizerInvocation {
        public void call(StatementCustomizer var1) throws SQLException;
    }
}

