/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.BaseStatement;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlLoggerUtil;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlStatements;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToCreateStatementException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Batch
extends BaseStatement<Batch> {
    private static final Logger LOG = LoggerFactory.getLogger(Batch.class);
    private final List<String> parts = new ArrayList<String>();

    public Batch(Handle handle) {
        super(handle);
    }

    public Batch add(String string) {
        this.parts.add(string);
        return this;
    }

    public int[] execute() {
        if (this.parts.isEmpty()) {
            return new int[0];
        }
        try {
            Statement statement;
            try {
                statement = this.getHandle().getStatementBuilder().create(this.getHandle().getConnection(), this.getContext());
                this.addCleanable(statement::close);
                this.getConfig(SqlStatements.class).customize(statement);
            }
            catch (SQLException sQLException) {
                throw new UnableToCreateStatementException(sQLException, this.getContext());
            }
            LOG.trace("Execute batch [");
            try {
                for (String string : this.parts) {
                    String string2 = this.getConfig(SqlStatements.class).getTemplateEngine().render(string, this.getContext());
                    LOG.trace(" {}", (Object)string2);
                    statement.addBatch(string2);
                }
            }
            catch (SQLException sQLException) {
                throw new UnableToExecuteStatementException("Unable to configure JDBC statement", sQLException, this.getContext());
            }
            try {
                Object object = SqlLoggerUtil.wrap(statement::executeBatch, this.getContext(), this.getConfig(SqlStatements.class).getSqlLogger());
                return object;
            }
            catch (SQLException sQLException) {
                throw new UnableToExecuteStatementException(Batch.mungeBatchException(sQLException), this.getContext());
            }
        }
        finally {
            this.close();
        }
    }

    static SQLException mungeBatchException(SQLException sQLException) {
        for (SQLException sQLException2 = sQLException.getNextException(); sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            sQLException.addSuppressed(sQLException2);
        }
        return sQLException;
    }
}

