/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.CallableStatementMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.OutParameters;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlStatement;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToExecuteStatementException;

public class Call
extends SqlStatement<Call> {
    private final List<OutParamArgument> params = new ArrayList<OutParamArgument>();

    public Call(Handle handle, String string) {
        super(handle, string);
    }

    public Call registerOutParameter(int n, int n2) {
        return this.registerOutParameter(n, n2, null);
    }

    public Call registerOutParameter(int n, int n2, CallableStatementMapper callableStatementMapper) {
        this.getBinding().addPositional(n, new OutParamArgument(n2, callableStatementMapper, null));
        return this;
    }

    public Call registerOutParameter(String string, int n) {
        return this.registerOutParameter(string, n, null);
    }

    public Call registerOutParameter(String string, int n, CallableStatementMapper callableStatementMapper) {
        this.getBinding().addNamed(string, new OutParamArgument(n, callableStatementMapper, string));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutParameters invoke() {
        try {
            PreparedStatement preparedStatement = this.internalExecute();
            OutParameters outParameters = new OutParameters();
            for (OutParamArgument outParamArgument : this.params) {
                Object object = outParamArgument.map((CallableStatement)preparedStatement);
                int n = outParamArgument.position - 1;
                outParameters.getMap().put(n, object);
                if (outParamArgument.name == null) continue;
                outParameters.getMap().put(outParamArgument.name, object);
            }
            OutParameters outParameters2 = outParameters;
            return outParameters2;
        }
        finally {
            this.close();
        }
    }

    private class OutParamArgument
    implements Argument {
        private final int sqlType;
        private final CallableStatementMapper mapper;
        private final String name;
        private int position;

        OutParamArgument(int n, CallableStatementMapper callableStatementMapper, String string) {
            this.sqlType = n;
            this.mapper = callableStatementMapper;
            this.name = string;
            Call.this.params.add(this);
        }

        @Override
        public void apply(int n, PreparedStatement preparedStatement, StatementContext statementContext) {
            ((CallableStatement)preparedStatement).registerOutParameter(n, this.sqlType);
            this.position = n;
        }

        public Object map(CallableStatement callableStatement) {
            try {
                if (this.mapper != null) {
                    return this.mapper.map(this.position, callableStatement);
                }
                switch (this.sqlType) {
                    case -16: 
                    case -9: 
                    case -1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        return callableStatement.getString(this.position);
                    }
                    case -3: 
                    case 2004: {
                        return callableStatement.getBytes(this.position);
                    }
                    case 5: {
                        return callableStatement.getShort(this.position);
                    }
                    case 4: {
                        return callableStatement.getInt(this.position);
                    }
                    case -5: {
                        return callableStatement.getLong(this.position);
                    }
                    case 92: 
                    case 93: {
                        return callableStatement.getTimestamp(this.position);
                    }
                    case 91: {
                        return callableStatement.getDate(this.position);
                    }
                    case 6: {
                        return Float.valueOf(callableStatement.getFloat(this.position));
                    }
                    case 3: 
                    case 8: {
                        return callableStatement.getDouble(this.position);
                    }
                }
                return callableStatement.getObject(this.position);
            }
            catch (SQLException sQLException) {
                throw new UnableToExecuteStatementException("Could not get OUT parameter from statement", sQLException, Call.this.getContext());
            }
        }
    }
}

