/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementBuilder;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementBuilderFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

public class DefaultStatementBuilder
implements StatementBuilder {
    public static final StatementBuilderFactory FACTORY = connection -> new DefaultStatementBuilder();

    @Override
    public Statement create(Connection connection, StatementContext statementContext) {
        return connection.createStatement();
    }

    @Override
    public PreparedStatement create(Connection connection, String string, StatementContext statementContext) {
        if (statementContext.isReturningGeneratedKeys()) {
            String[] stringArray = statementContext.getGeneratedKeysColumnNames();
            if (stringArray != null && stringArray.length > 0) {
                return connection.prepareStatement(string, stringArray);
            }
            return connection.prepareStatement(string, 1);
        }
        if (statementContext.isConcurrentUpdatable()) {
            return connection.prepareStatement(string, 1003, 1008);
        }
        return connection.prepareStatement(string, 1003, 1007);
    }

    @Override
    public void close(Connection connection, String string, Statement statement) {
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public void close(Connection connection) {
    }

    @Override
    public CallableStatement createCall(Connection connection, String string, StatementContext statementContext) {
        return connection.prepareCall(string);
    }
}

