/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.Unchecked;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Binding;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementCustomizer;

class DefineNamedBindingsStatementCustomizer
implements StatementCustomizer {
    DefineNamedBindingsStatementCustomizer() {
    }

    @Override
    public void beforeTemplating(PreparedStatement preparedStatement, StatementContext statementContext) {
        Set<String> set = statementContext.getAttributes().keySet();
        Binding binding = statementContext.getBinding();
        SetNullHandler setNullHandler = new SetNullHandler(statementContext);
        binding.getNames().stream().filter(string -> !set.contains(string)).forEach(string -> binding.findForName((String)string, statementContext).ifPresent(argument -> setNullHandler.define((String)string, (Argument)argument)));
    }

    private static class SetNullHandler
    implements InvocationHandler {
        private static final Map<Class<?>, Object> DEFAULT_VALUES = Stream.of(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE).collect(Collectors.toMap(Function.identity(), SetNullHandler::defaultValue));
        private final StatementContext ctx;
        private final PreparedStatement fakeStmt = (PreparedStatement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)this);
        private boolean setNull;
        private boolean setCalled;

        SetNullHandler(StatementContext statementContext) {
            this.ctx = statementContext;
        }

        private static Object defaultValue(Class<?> clazz) {
            return Array.get(Array.newInstance(clazz, 1), 0);
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) {
            if (method.getName().equals("unwrap") && objectArray.length == 1 && method.getParameterTypes()[0].equals(Class.class)) {
                throw new SQLException("The current implementation of DefineNamedBindings is incompatible with arguments that rely on java.sql.Wrapper.unwrap(Class<?>)");
            }
            if (method.getName().equals("getConnection")) {
                return this.ctx.getConnection();
            }
            if (method.getName().startsWith("set")) {
                this.setCalled = true;
                boolean bl = objectArray.length > 1 && objectArray[1] == null;
                this.setNull = bl || "setNull".equals(method.getName());
            }
            return DEFAULT_VALUES.get(method.getReturnType());
        }

        void define(String string, Argument argument) {
            this.setNull = false;
            this.setCalled = false;
            Unchecked.runnable(() -> argument.apply(1, this.fakeStmt, this.ctx)).run();
            if (this.setCalled) {
                this.ctx.define(string, !this.setNull);
            }
        }
    }
}

