/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultBearing;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultIterator;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultProducer;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultProducers;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultSetScanner;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.UnableToProduceResultException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.ArgumentBinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Batch;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Binding;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.ParsedParameters;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.ParsedSql;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlLoggerUtil;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlStatement;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlStatements;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementBuilder;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToCreateStatementException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToExecuteStatementException;

public class PreparedBatch
extends SqlStatement<PreparedBatch>
implements ResultBearing {
    private final List<Binding> bindings = new ArrayList<Binding>();

    public PreparedBatch(Handle handle, String string) {
        super(handle, string);
    }

    @Override
    public <R> R scanResultSet(ResultSetScanner<R> resultSetScanner) {
        return this.execute(ResultProducers.returningResults()).scanResultSet(resultSetScanner);
    }

    public int[] execute() {
        return this.internalBatchExecute().updateCounts;
    }

    public ResultIterator<Integer> executeAndGetModCount() {
        final StatementContext statementContext = this.getContext();
        final int[] nArray = this.execute();
        return new ResultIterator<Integer>(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < nArray.length;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return nArray[this.pos++];
            }

            @Override
            public StatementContext getContext() {
                return statementContext;
            }

            @Override
            public void close() {
                statementContext.close();
            }
        };
    }

    public ResultBearing executeAndReturnGeneratedKeys(String ... stringArray) {
        return this.execute(ResultProducers.returningGeneratedKeys(stringArray));
    }

    public <R> R execute(ResultProducer<R> resultProducer) {
        try {
            return resultProducer.produce(() -> this.internalBatchExecute().stmt, this.getContext());
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (Exception exception) {
                sQLException.addSuppressed(exception);
            }
            throw new UnableToProduceResultException("Exception producing batch result", sQLException, this.getContext());
        }
    }

    private ExecutedBatch internalBatchExecute() {
        if (!this.getBinding().isEmpty()) {
            this.add();
        }
        if (this.bindings.isEmpty()) {
            throw new IllegalStateException("No batch parts to execute");
        }
        this.beforeTemplating();
        String string = this.getConfig(SqlStatements.class).getTemplateEngine().render(this.getSql(), this.getContext());
        this.getContext().setRenderedSql(string);
        ParsedSql parsedSql = this.getConfig(SqlStatements.class).getSqlParser().parse(string, this.getContext());
        String string2 = parsedSql.getSql();
        ParsedParameters parsedParameters = parsedSql.getParameters();
        this.getContext().setParsedSql(parsedSql);
        try {
            Object object2;
            try {
                object2 = this.getHandle().getStatementBuilder();
                Connection object3 = this.getHandle().getConnection();
                this.stmt = object2.create(object3, string2, this.getContext());
                this.addCleanable(() -> this.lambda$internalBatchExecute$1((StatementBuilder)object2, object3, string2));
                this.getConfig(SqlStatements.class).customize(this.stmt);
            }
            catch (SQLException sQLException) {
                throw new UnableToCreateStatementException(sQLException, this.getContext());
            }
            this.beforeBinding();
            try {
                for (Binding binding : this.bindings) {
                    this.getContext().setBinding(binding);
                    ArgumentBinder.bind(parsedParameters, binding, this.stmt, this.getContext());
                    this.stmt.addBatch();
                }
            }
            catch (SQLException sQLException) {
                throw new UnableToExecuteStatementException("Exception while binding parameters", sQLException, this.getContext());
            }
            this.beforeExecution();
            try {
                object2 = SqlLoggerUtil.wrap(this.stmt::executeBatch, this.getContext(), this.getConfig(SqlStatements.class).getSqlLogger());
                this.afterExecution();
                this.getContext().setBinding(new Binding());
                ExecutedBatch executedBatch = new ExecutedBatch(this.stmt, (int[])object2);
                return executedBatch;
            }
            catch (SQLException sQLException) {
                throw new UnableToExecuteStatementException(Batch.mungeBatchException(sQLException), this.getContext());
            }
        }
        finally {
            this.bindings.clear();
        }
    }

    public PreparedBatch add() {
        Binding binding = this.getBinding();
        if (binding.isEmpty()) {
            throw new IllegalStateException("Attempt to add() an empty batch, you probably didn't mean to do this - call add() *after* setting batch parameters");
        }
        this.bindings.add(binding);
        this.getContext().setBinding(new Binding());
        return this;
    }

    public PreparedBatch add(Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.bind(i, objectArray[i]);
        }
        this.add();
        return this;
    }

    public PreparedBatch add(Map<String, ?> map) {
        this.bindMap(map);
        this.add();
        return this;
    }

    public int size() {
        return this.bindings.size();
    }

    private /* synthetic */ void lambda$internalBatchExecute$1(StatementBuilder statementBuilder, Connection connection, String string) {
        statementBuilder.close(connection, string, this.stmt);
    }

    private static class ExecutedBatch {
        final PreparedStatement stmt;
        final int[] updateCounts;

        ExecutedBatch(PreparedStatement preparedStatement, int[] nArray) {
            this.stmt = preparedStatement;
            this.updateCounts = Arrays.copyOf(nArray, nArray.length);
        }
    }
}

