/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.sql.SQLException;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultBearing;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultProducer;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultProducers;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultSetScanner;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.UnableToProduceResultException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlStatement;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementCustomizers;

public class Query
extends SqlStatement<Query>
implements ResultBearing {
    public Query(Handle handle, String string) {
        super(handle, string);
    }

    public <R> R execute(ResultProducer<R> resultProducer) {
        try {
            return resultProducer.produce(this::internalExecute, this.getContext());
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (Exception exception) {
                sQLException.addSuppressed(exception);
            }
            throw new UnableToProduceResultException(sQLException, this.getContext());
        }
    }

    @Override
    public <R> R scanResultSet(ResultSetScanner<R> resultSetScanner) {
        return this.execute(ResultProducers.returningResults()).scanResultSet(resultSetScanner);
    }

    public Query setFetchSize(int n) {
        return (Query)this.addCustomizer(StatementCustomizers.fetchSize(n));
    }

    public Query setMaxRows(int n) {
        return (Query)this.addCustomizer(StatementCustomizers.maxRows(n));
    }

    public Query setMaxFieldSize(int n) {
        return (Query)this.addCustomizer(StatementCustomizers.maxFieldSize(n));
    }

    public Query concurrentUpdatable() {
        this.getContext().setConcurrentUpdatable(true);
        return this;
    }
}

