/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.util.ArrayList;
import java.util.List;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.SqlScriptParser;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Batch;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlStatement;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlStatements;
import org.antlr.v4.runtime.CharStreams;

public class Script
extends SqlStatement<Script> {
    private final Handle handle;
    private final String sql;

    public Script(Handle handle, String string) {
        super(handle, string);
        this.handle = handle;
        this.sql = string;
    }

    public int[] execute() {
        List<String> list2 = this.getStatements();
        Batch batch = this.handle.createBatch();
        list2.forEach(batch::add);
        return batch.execute();
    }

    public void executeAsSeparateStatements() {
        for (String string : this.getStatements()) {
            this.handle.execute(string, new Object[0]);
        }
    }

    public List<String> getStatements() {
        return this.splitToStatements(this.getConfig(SqlStatements.class).getTemplateEngine().render(this.sql, this.getContext()));
    }

    private List<String> splitToStatements(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = new SqlScriptParser((token, stringBuilder) -> {
            this.addStatement(stringBuilder.toString(), arrayList);
            stringBuilder.setLength(0);
        }).parse(CharStreams.fromString(string));
        this.addStatement(string2, arrayList);
        return arrayList;
    }

    private void addStatement(String string, List<String> list2) {
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return;
        }
        list2.add(string2);
    }
}

