/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.sql.Statement;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.ColonPrefixSqlParser;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.DefinedAttributeTemplateEngine;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlLogger;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlParser;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementCustomizer;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.TemplateEngine;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.TimingCollector;
import me.glaremasters.guilds.libs.jdbi.v3.meta.Beta;

public final class SqlStatements
implements JdbiConfig<SqlStatements> {
    private final Map<String, Object> attributes;
    private TemplateEngine templateEngine;
    private SqlParser sqlParser;
    private SqlLogger sqlLogger;
    private Integer queryTimeout;
    private boolean allowUnusedBindings;
    private final Collection<StatementCustomizer> customizers = new CopyOnWriteArrayList<StatementCustomizer>();

    public SqlStatements() {
        this.attributes = Collections.synchronizedMap(new HashMap());
        this.templateEngine = new DefinedAttributeTemplateEngine();
        this.sqlParser = new ColonPrefixSqlParser();
        this.sqlLogger = SqlLogger.NOP_SQL_LOGGER;
        this.queryTimeout = null;
    }

    private SqlStatements(SqlStatements sqlStatements) {
        this.attributes = Collections.synchronizedMap(sqlStatements.getAttributes());
        this.templateEngine = sqlStatements.templateEngine;
        this.sqlParser = sqlStatements.sqlParser;
        this.sqlLogger = sqlStatements.sqlLogger;
        this.queryTimeout = sqlStatements.queryTimeout;
        this.allowUnusedBindings = sqlStatements.allowUnusedBindings;
        this.customizers.addAll(sqlStatements.customizers);
    }

    public SqlStatements define(String string, Object object) {
        this.attributes.put(string, object);
        return this;
    }

    public SqlStatements defineMap(Map<String, ?> map) {
        if (map != null) {
            this.attributes.putAll(map);
        }
        return this;
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(this.attributes);
    }

    public SqlStatements addCustomizer(StatementCustomizer statementCustomizer) {
        this.customizers.add(statementCustomizer);
        return this;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public SqlStatements setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        return this;
    }

    public SqlParser getSqlParser() {
        return this.sqlParser;
    }

    public SqlStatements setSqlParser(SqlParser sqlParser) {
        this.sqlParser = sqlParser;
        return this;
    }

    @Deprecated
    public TimingCollector getTimingCollector() {
        return (l, statementContext) -> this.sqlLogger.logAfterExecution(statementContext);
    }

    @Deprecated
    public SqlStatements setTimingCollector(final TimingCollector timingCollector) {
        this.sqlLogger = timingCollector == null ? SqlLogger.NOP_SQL_LOGGER : new SqlLogger(){

            @Override
            public void logAfterExecution(StatementContext statementContext) {
                timingCollector.collect(statementContext.getElapsedTime(ChronoUnit.NANOS), statementContext);
            }
        };
        return this;
    }

    public SqlLogger getSqlLogger() {
        return this.sqlLogger;
    }

    public SqlStatements setSqlLogger(SqlLogger sqlLogger) {
        this.sqlLogger = sqlLogger == null ? SqlLogger.NOP_SQL_LOGGER : sqlLogger;
        return this;
    }

    @Beta
    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    @Beta
    public SqlStatements setQueryTimeout(@Nullable Integer n) {
        if (n != null && n < 0) {
            throw new IllegalArgumentException("queryTimeout must not be < 0");
        }
        this.queryTimeout = n;
        return this;
    }

    public boolean isUnusedBindingAllowed() {
        return this.allowUnusedBindings;
    }

    public SqlStatements setUnusedBindingAllowed(boolean bl) {
        this.allowUnusedBindings = bl;
        return this;
    }

    void customize(Statement statement) {
        if (this.queryTimeout != null) {
            statement.setQueryTimeout(this.queryTimeout);
        }
    }

    @Override
    public SqlStatements createCopy() {
        return new SqlStatements(this);
    }

    Collection<StatementCustomizer> getCustomizers() {
        return this.customizers;
    }
}

