/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.HandleCallback;
import me.glaremasters.guilds.libs.jdbi.v3.core.transaction.TransactionException;
import me.glaremasters.guilds.libs.jdbi.v3.core.transaction.TransactionHandler;
import me.glaremasters.guilds.libs.jdbi.v3.core.transaction.TransactionIsolationLevel;
import me.glaremasters.guilds.libs.jdbi.v3.core.transaction.UnableToRestoreAutoCommitStateException;

public class LocalTransactionHandler
implements TransactionHandler {
    private final ConcurrentHashMap<Handle, LocalStuff> localStuff = new ConcurrentHashMap();
    private final ThreadLocal<Boolean> didTxnRollback = ThreadLocal.withInitial(() -> false);

    @Override
    public void begin(Handle handle) {
        try {
            if (!this.localStuff.containsKey(handle)) {
                boolean bl = handle.getConnection().getAutoCommit();
                this.localStuff.putIfAbsent(handle, new LocalStuff(bl));
                handle.getConnection().setAutoCommit(false);
            }
        }
        catch (SQLException sQLException) {
            throw new TransactionException("Failed to start transaction", sQLException);
        }
    }

    @Override
    public void commit(Handle handle) {
        try {
            handle.getConnection().commit();
        }
        catch (SQLException sQLException) {
            throw new TransactionException("Failed to commit transaction", sQLException);
        }
        finally {
            this.restoreAutoCommitState(handle);
        }
    }

    @Override
    public void rollback(Handle handle) {
        this.didTxnRollback.set(true);
        try {
            handle.getConnection().rollback();
        }
        catch (SQLException sQLException) {
            throw new TransactionException("Failed to rollback transaction", sQLException);
        }
        finally {
            this.restoreAutoCommitState(handle);
        }
    }

    @Override
    public void savepoint(Handle handle, String string) {
        Connection connection = handle.getConnection();
        try {
            Savepoint savepoint = connection.setSavepoint(string);
            this.localStuff.get(handle).getSavepoints().put(string, savepoint);
        }
        catch (SQLException sQLException) {
            throw new TransactionException(String.format("Unable to create savepoint '%s'", string), sQLException);
        }
    }

    @Override
    public void releaseSavepoint(Handle handle, String string) {
        Connection connection = handle.getConnection();
        try {
            Savepoint savepoint = this.localStuff.get(handle).getSavepoints().remove(string);
            if (savepoint == null) {
                throw new TransactionException(String.format("Attempt to release non-existent savepoint, '%s'", string));
            }
            connection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            throw new TransactionException(String.format("Unable to create savepoint %s", string), sQLException);
        }
    }

    @Override
    public void rollbackToSavepoint(Handle handle, String string) {
        Connection connection = handle.getConnection();
        try {
            Savepoint savepoint = this.localStuff.get(handle).getSavepoints().remove(string);
            if (savepoint == null) {
                throw new TransactionException(String.format("Attempt to rollback to non-existent savepoint, '%s'", string));
            }
            connection.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            throw new TransactionException(String.format("Unable to create savepoint %s", string), sQLException);
        }
    }

    @Override
    public boolean isInTransaction(Handle handle) {
        try {
            return !handle.getConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw new TransactionException("Failed to test for transaction status", sQLException);
        }
    }

    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, HandleCallback<R, X> handleCallback) {
        R r;
        if (this.isInTransaction(handle)) {
            throw new IllegalStateException("Already in transaction");
        }
        this.didTxnRollback.set(false);
        try {
            handle.begin();
            r = handleCallback.withHandle(handle);
            if (!this.didTxnRollback.get().booleanValue()) {
                handle.commit();
            }
        }
        catch (Throwable throwable) {
            try {
                handle.rollback();
            }
            catch (Exception exception) {
                throwable.addSuppressed(exception);
            }
            throw throwable;
        }
        this.didTxnRollback.remove();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, TransactionIsolationLevel transactionIsolationLevel, HandleCallback<R, X> handleCallback) {
        TransactionIsolationLevel transactionIsolationLevel2 = handle.getTransactionIsolationLevel();
        try {
            handle.setTransactionIsolation(transactionIsolationLevel);
            R r = this.inTransaction(handle, handleCallback);
            return r;
        }
        finally {
            handle.setTransactionIsolation(transactionIsolationLevel2);
        }
    }

    private void restoreAutoCommitState(Handle handle) {
        try {
            LocalStuff localStuff = this.localStuff.remove(handle);
            if (localStuff != null) {
                handle.getConnection().setAutoCommit(localStuff.getInitialAutocommit());
                localStuff.getSavepoints().clear();
            }
        }
        catch (SQLException sQLException) {
            throw new UnableToRestoreAutoCommitStateException(sQLException);
        }
        finally {
            this.localStuff.remove(handle);
        }
    }

    private static class LocalStuff {
        private final Map<String, Savepoint> savepoints = new HashMap<String, Savepoint>();
        private final boolean initialAutocommit;

        LocalStuff(boolean bl) {
            this.initialAutocommit = bl;
        }

        Map<String, Savepoint> getSavepoints() {
            return this.savepoints;
        }

        boolean getInitialAutocommit() {
            return this.initialAutocommit;
        }
    }
}

