/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.sqlobject;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.Unchecked;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.DefaultMethodHandler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.Handler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.HandlerFactory;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;

class BridgeMethodHandlerFactory
implements HandlerFactory {
    BridgeMethodHandlerFactory() {
    }

    @Override
    public Optional<Handler> buildHandler(Class<?> clazz, Method method3) {
        if (!method3.isBridge()) {
            return Optional.empty();
        }
        return Stream.of(clazz.getMethods()).filter(method2 -> !method2.isBridge() && Objects.equals(method2.getName(), method3.getName()) && method2.getParameterCount() == method3.getParameterCount()).filter(method2 -> {
            Class[] classArray = method2.getParameterTypes();
            Class[] classArray2 = method3.getParameterTypes();
            return IntStream.range(0, method3.getParameterCount()).allMatch(n -> classArray2[n].isAssignableFrom(classArray[n]));
        }).map(method -> {
            MethodHandle methodHandle = BridgeMethodHandlerFactory.unreflect(clazz, method);
            return (object, objectArray, handleSupplier) -> Unchecked.function(methodHandle.bindTo(object)::invokeWithArguments).apply(objectArray);
        }).findFirst();
    }

    private static MethodHandle unreflect(Class<?> clazz, Method method) {
        try {
            return DefaultMethodHandler.lookupFor(clazz).unreflect(method);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnableToCreateSqlObjectException("Bridge handler couldn't unreflect " + clazz + " " + method, illegalAccessException);
        }
    }
}

