/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.Method;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultIterable;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Query;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.UseRowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.UseRowReducer;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.CustomizingStatementHandler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.ResultReturner;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class SqlQueryHandler
extends CustomizingStatementHandler<Query> {
    private final ResultReturner magic;

    public SqlQueryHandler(Class<?> clazz, Method method) {
        super(clazz, method);
        this.magic = ResultReturner.forMethod(clazz, method);
    }

    @Override
    void configureReturner(Query query, SqlObjectStatementConfiguration sqlObjectStatementConfiguration) {
        UseRowMapper useRowMapper = this.getMethod().getAnnotation(UseRowMapper.class);
        UseRowReducer useRowReducer = this.getMethod().getAnnotation(UseRowReducer.class);
        if (useRowReducer != null && useRowMapper != null) {
            throw new IllegalStateException("Cannot declare @UseRowMapper and @UseRowReducer on the same method.");
        }
        sqlObjectStatementConfiguration.setReturner(() -> {
            StatementContext statementContext = query.getContext();
            QualifiedType<?> qualifiedType = this.magic.elementType(statementContext);
            if (useRowReducer != null) {
                return this.magic.reducedResult(query.reduceRows(SqlQueryHandler.rowReducerFor(useRowReducer)), statementContext);
            }
            ResultIterable<?> resultIterable = useRowMapper == null ? query.mapTo(qualifiedType) : query.map(SqlQueryHandler.rowMapperFor(useRowMapper));
            return this.magic.mappedResult(resultIterable, statementContext);
        });
    }

    @Override
    Query createStatement(Handle handle, String string) {
        return handle.createQuery(string);
    }
}

