/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.app.builder;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import me.glaremasters.guilds.libs.slimjar.app.Application;
import me.glaremasters.guilds.libs.slimjar.app.builder.ApplicationBuilder;
import me.glaremasters.guilds.libs.slimjar.app.builder.IsolationConfiguration;
import me.glaremasters.guilds.libs.slimjar.injector.DependencyInjector;
import me.glaremasters.guilds.libs.slimjar.injector.loader.IsolatedInjectableClassLoader;
import me.glaremasters.guilds.libs.slimjar.resolver.ResolutionResult;
import me.glaremasters.guilds.libs.slimjar.resolver.data.DependencyData;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.dependency.DependencyDataProvider;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.resolution.PreResolutionDataProvider;
import me.glaremasters.guilds.libs.slimjar.util.Modules;
import me.glaremasters.guilds.libs.slimjar.util.Parameters;

public final class IsolatedApplicationBuilder
extends ApplicationBuilder {
    private final IsolationConfiguration isolationConfiguration;
    private final Object[] arguments;

    public IsolatedApplicationBuilder(String string, IsolationConfiguration isolationConfiguration, Object[] objectArray) {
        super(string);
        this.isolationConfiguration = isolationConfiguration;
        this.arguments = (Object[])objectArray.clone();
    }

    @Override
    public Application buildApplication() {
        DependencyInjector dependencyInjector = this.createInjector();
        URL[] uRLArray = Modules.extract(this.isolationConfiguration.getModuleExtractor(), this.isolationConfiguration.getModules());
        IsolatedInjectableClassLoader isolatedInjectableClassLoader = new IsolatedInjectableClassLoader(uRLArray, this.isolationConfiguration.getParentClassloader(), Collections.singleton(Application.class));
        DependencyDataProvider dependencyDataProvider = this.getDataProviderFactory().create(this.getDependencyFileUrl());
        DependencyData dependencyData = dependencyDataProvider.get();
        PreResolutionDataProvider preResolutionDataProvider = this.getPreResolutionDataProviderFactory().create(this.getPreResolutionFileUrl());
        Map<String, ResolutionResult> map = preResolutionDataProvider.get();
        dependencyInjector.inject(isolatedInjectableClassLoader, dependencyData, map);
        for (URL uRL : uRLArray) {
            DependencyDataProvider dependencyDataProvider2 = this.getModuleDataProviderFactory().create(uRL);
            DependencyData dependencyData2 = dependencyDataProvider2.get();
            dependencyInjector.inject(isolatedInjectableClassLoader, dependencyData2, map);
        }
        Class<?> clazz = Class.forName(this.isolationConfiguration.getApplicationClass(), true, isolatedInjectableClassLoader);
        return (Application)clazz.getConstructor(Parameters.typesFrom(this.arguments)).newInstance(this.arguments);
    }
}

