/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.downloader.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.glaremasters.guilds.libs.slimjar.downloader.output.OutputWriter;

public final class ChanneledFileOutputWriter
implements OutputWriter {
    private static final Logger LOGGER = Logger.getLogger(ChanneledFileOutputWriter.class.getName());
    private final File outputFile;

    public ChanneledFileOutputWriter(File file) {
        this.outputFile = file;
    }

    @Override
    public File writeFrom(InputStream inputStream, long l) {
        LOGGER.log(Level.FINE, "Attempting to write from inputStream...");
        if (!this.outputFile.exists()) {
            LOGGER.log(Level.FINE, "Writing {0} bytes...", l);
            try (ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
                 FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);){
                fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, l);
            }
        }
        inputStream.close();
        return this.outputFile;
    }
}

