/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.downloader.output;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.glaremasters.guilds.libs.slimjar.downloader.output.ChanneledFileOutputWriter;
import me.glaremasters.guilds.libs.slimjar.downloader.output.OutputWriter;
import me.glaremasters.guilds.libs.slimjar.downloader.output.OutputWriterFactory;
import me.glaremasters.guilds.libs.slimjar.downloader.strategy.FilePathStrategy;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;

public final class DependencyOutputWriterFactory
implements OutputWriterFactory {
    private static final Logger LOGGER = Logger.getLogger(DependencyOutputWriterFactory.class.getName());
    private final FilePathStrategy outputFilePathStrategy;

    public DependencyOutputWriterFactory(FilePathStrategy filePathStrategy) {
        this.outputFilePathStrategy = filePathStrategy;
    }

    @Override
    public OutputWriter create(Dependency dependency) {
        LOGGER.log(Level.FINEST, "Creating OutputWriter for {0}", dependency.getArtifactId());
        File file = this.outputFilePathStrategy.selectFileFor(dependency);
        file.getParentFile().mkdirs();
        return new ChanneledFileOutputWriter(file);
    }

    @Override
    public FilePathStrategy getStrategy() {
        return this.outputFilePathStrategy;
    }
}

