/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.downloader.verify;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.Objects;
import java.util.Optional;
import me.glaremasters.guilds.libs.slimjar.downloader.output.OutputWriter;
import me.glaremasters.guilds.libs.slimjar.downloader.output.OutputWriterFactory;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.ChecksumCalculator;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.DependencyVerifier;
import me.glaremasters.guilds.libs.slimjar.logging.LogDispatcher;
import me.glaremasters.guilds.libs.slimjar.logging.ProcessLogger;
import me.glaremasters.guilds.libs.slimjar.resolver.DependencyResolver;
import me.glaremasters.guilds.libs.slimjar.resolver.ResolutionResult;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;
import me.glaremasters.guilds.libs.slimjar.util.Connections;

public final class ChecksumDependencyVerifier
implements DependencyVerifier {
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final DependencyResolver resolver;
    private final OutputWriterFactory outputWriterFactory;
    private final DependencyVerifier fallbackVerifier;
    private final ChecksumCalculator checksumCalculator;

    public ChecksumDependencyVerifier(DependencyResolver dependencyResolver, OutputWriterFactory outputWriterFactory, DependencyVerifier dependencyVerifier, ChecksumCalculator checksumCalculator) {
        this.resolver = dependencyResolver;
        this.outputWriterFactory = outputWriterFactory;
        this.fallbackVerifier = dependencyVerifier;
        this.checksumCalculator = checksumCalculator;
    }

    @Override
    public boolean verify(File file, Dependency dependency) {
        if (!file.exists()) {
            return false;
        }
        LOGGER.log("Verifying checksum for {0}", dependency.getArtifactId());
        File file2 = this.outputWriterFactory.getStrategy().selectFileFor(dependency);
        file2.getParentFile().mkdirs();
        if (!file2.exists() && !this.prepareChecksumFile(file2, dependency)) {
            LOGGER.log("Unable to resolve checksum for {0}, falling back to fallbackVerifier!", dependency.getArtifactId());
            return this.fallbackVerifier.verify(file, dependency);
        }
        if (file2.length() == 0L) {
            LOGGER.log("Required checksum not found for {0}, using fallbackVerifier!", dependency.getArtifactId());
            return this.fallbackVerifier.verify(file, dependency);
        }
        String string = this.checksumCalculator.calculate(file);
        String string2 = new String(Files.readAllBytes(file2.toPath())).trim();
        LOGGER.debug("{0} -> Actual checksum: {1};", dependency.getArtifactId(), string);
        LOGGER.debug("{0} -> Expected checksum: {1};", dependency.getArtifactId(), string2);
        boolean bl = Objects.equals(string, string2);
        LOGGER.log("Checksum {0} for {1}", bl ? "matched" : "match failed", dependency.getArtifactId());
        return Objects.equals(string, string2);
    }

    @Override
    public File getChecksumFile(Dependency dependency) {
        File file = this.outputWriterFactory.getStrategy().selectFileFor(dependency);
        file.getParentFile().mkdirs();
        return file;
    }

    private boolean prepareChecksumFile(File file, Dependency dependency) {
        Optional<ResolutionResult> optional = this.resolver.resolve(dependency);
        if (!optional.isPresent()) {
            return false;
        }
        URL uRL = optional.get().getChecksumURL();
        LOGGER.log("Resolved checksum URL for {0} as {1}", dependency.getArtifactId(), uRL);
        if (uRL == null) {
            file.createNewFile();
            return true;
        }
        URLConnection uRLConnection = Connections.createDownloadConnection(uRL);
        InputStream inputStream = uRLConnection.getInputStream();
        OutputWriter outputWriter = this.outputWriterFactory.create(dependency);
        outputWriter.writeFrom(inputStream, uRLConnection.getContentLength());
        Connections.tryDisconnect(uRLConnection);
        LOGGER.log("Downloaded checksum for {0}", dependency.getArtifactId());
        return true;
    }
}

