/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.downloader.verify;

import java.util.logging.Level;
import java.util.logging.Logger;
import me.glaremasters.guilds.libs.slimjar.downloader.output.OutputWriterFactory;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.ChecksumCalculator;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.ChecksumDependencyVerifier;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.DependencyVerifier;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.DependencyVerifierFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.DependencyResolver;

public final class ChecksumDependencyVerifierFactory
implements DependencyVerifierFactory {
    private static final Logger LOGGER = Logger.getLogger(ChecksumDependencyVerifierFactory.class.getName());
    private final OutputWriterFactory outputWriterFactory;
    private final DependencyVerifierFactory fallbackVerifierFactory;
    private final ChecksumCalculator checksumCalculator;

    public ChecksumDependencyVerifierFactory(OutputWriterFactory outputWriterFactory, DependencyVerifierFactory dependencyVerifierFactory, ChecksumCalculator checksumCalculator) {
        this.outputWriterFactory = outputWriterFactory;
        this.fallbackVerifierFactory = dependencyVerifierFactory;
        this.checksumCalculator = checksumCalculator;
    }

    @Override
    public DependencyVerifier create(DependencyResolver dependencyResolver) {
        LOGGER.log(Level.FINEST, "Creating verifier...");
        return new ChecksumDependencyVerifier(dependencyResolver, this.outputWriterFactory, this.fallbackVerifierFactory.create(dependencyResolver), this.checksumCalculator);
    }
}

