/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.downloader.verify;

import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.ChecksumCalculator;

public final class FileChecksumCalculator
implements ChecksumCalculator {
    private static final String DIRECTORY_HASH = "DIRECTORY";
    private static final Logger LOGGER = Logger.getLogger(FileChecksumCalculator.class.getName());
    private final MessageDigest digest;

    public FileChecksumCalculator(String string) {
        this.digest = MessageDigest.getInstance(string);
    }

    @Override
    public String calculate(File file) {
        Object object;
        LOGGER.log(Level.FINEST, "Calculating hash for {0}", file.getPath());
        if (file.isDirectory()) {
            return DIRECTORY_HASH;
        }
        this.digest.reset();
        try (Object object2 = new FileInputStream(file);){
            int n;
            object = new byte[1024];
            while ((n = ((FileInputStream)object2).read((byte[])object)) != -1) {
                this.digest.update((byte[])object, 0, n);
            }
        }
        object2 = this.digest.digest();
        object = new StringBuilder();
        for (Object object3 : object2) {
            ((StringBuilder)object).append(Integer.toString((object3 & 0xFF) + 256, 16).substring(1));
        }
        ((StringBuilder)object).trimToSize();
        String string = ((StringBuilder)object).toString();
        LOGGER.log(Level.FINEST, "Hash for {0} -> {1}", new Object[]{file.getPath(), string});
        return string;
    }
}

