/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.injector;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import me.glaremasters.guilds.libs.slimjar.injector.DependencyInjector;
import me.glaremasters.guilds.libs.slimjar.injector.InjectionFailedException;
import me.glaremasters.guilds.libs.slimjar.injector.helper.InjectionHelper;
import me.glaremasters.guilds.libs.slimjar.injector.helper.InjectionHelperFactory;
import me.glaremasters.guilds.libs.slimjar.injector.loader.Injectable;
import me.glaremasters.guilds.libs.slimjar.resolver.ResolutionResult;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;
import me.glaremasters.guilds.libs.slimjar.resolver.data.DependencyData;

public final class SimpleDependencyInjector
implements DependencyInjector {
    private final InjectionHelperFactory injectionHelperFactory;

    public SimpleDependencyInjector(InjectionHelperFactory injectionHelperFactory) {
        this.injectionHelperFactory = injectionHelperFactory;
    }

    @Override
    public void inject(Injectable injectable, DependencyData dependencyData, Map<String, ResolutionResult> map) {
        InjectionHelper injectionHelper = this.injectionHelperFactory.create(dependencyData, map);
        this.injectDependencies(injectable, injectionHelper, dependencyData.getDependencies());
    }

    private void injectDependencies(Injectable injectable, InjectionHelper injectionHelper, Collection<Dependency> collection) {
        for (Dependency dependency : collection) {
            try {
                File file = injectionHelper.fetch(dependency);
                if (file == null) continue;
                injectable.inject(file.toURI().toURL());
                this.injectDependencies(injectable, injectionHelper, dependency.getTransitive());
            }
            catch (IOException iOException) {
                throw new InjectionFailedException(dependency, iOException);
            }
            catch (IllegalAccessException | InvocationTargetException | URISyntaxException exception) {
                exception.printStackTrace();
            }
        }
    }
}

