/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.injector.agent;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.UUID;
import me.glaremasters.guilds.libs.slimjar.app.builder.ApplicationBuilder;
import me.glaremasters.guilds.libs.slimjar.app.module.ModuleExtractor;
import me.glaremasters.guilds.libs.slimjar.app.module.TemporaryModuleExtractor;
import me.glaremasters.guilds.libs.slimjar.injector.agent.InstrumentationFactory;
import me.glaremasters.guilds.libs.slimjar.injector.loader.InstrumentationInjectable;
import me.glaremasters.guilds.libs.slimjar.injector.loader.IsolatedInjectableClassLoader;
import me.glaremasters.guilds.libs.slimjar.injector.loader.manifest.JarManifestGenerator;
import me.glaremasters.guilds.libs.slimjar.relocation.JarFileRelocator;
import me.glaremasters.guilds.libs.slimjar.relocation.PassthroughRelocator;
import me.glaremasters.guilds.libs.slimjar.relocation.RelocationRule;
import me.glaremasters.guilds.libs.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;
import me.glaremasters.guilds.libs.slimjar.resolver.data.DependencyData;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;
import me.glaremasters.guilds.libs.slimjar.util.Packages;

public final class ByteBuddyInstrumentationFactory
implements InstrumentationFactory {
    public static final String AGENT_JAR = "loader-agent.isolated-jar";
    private static final String AGENT_PACKAGE = "io#github#slimjar#injector#agent";
    private static final String AGENT_CLASS = "ClassLoaderAgent";
    private static final String BYTE_BUDDY_AGENT_CLASS = "net#bytebuddy#agent#ByteBuddyAgent";
    private final URL agentJarUrl;
    private final ModuleExtractor extractor;
    private final JarRelocatorFacadeFactory relocatorFacadeFactory;

    public ByteBuddyInstrumentationFactory(JarRelocatorFacadeFactory jarRelocatorFacadeFactory) {
        this.relocatorFacadeFactory = jarRelocatorFacadeFactory;
        this.agentJarUrl = InstrumentationInjectable.class.getClassLoader().getResource(AGENT_JAR);
        this.extractor = new TemporaryModuleExtractor();
    }

    public ByteBuddyInstrumentationFactory(URL uRL, ModuleExtractor moduleExtractor, JarRelocatorFacadeFactory jarRelocatorFacadeFactory) {
        this.agentJarUrl = uRL;
        this.extractor = moduleExtractor;
        this.relocatorFacadeFactory = jarRelocatorFacadeFactory;
    }

    @Override
    public Instrumentation create() {
        URL uRL2 = this.extractor.extractModule(this.agentJarUrl, "loader-agent");
        String string = ByteBuddyInstrumentationFactory.generatePattern();
        String string2 = String.format("%s.%s", string, AGENT_CLASS);
        RelocationRule relocationRule = new RelocationRule(Packages.fix(AGENT_PACKAGE), string, Collections.emptySet(), Collections.emptySet());
        JarFileRelocator jarFileRelocator = new JarFileRelocator(Collections.singleton(relocationRule), this.relocatorFacadeFactory);
        File file = new File(uRL2.toURI());
        File file2 = File.createTempFile("slimjar-agent", ".jar");
        IsolatedInjectableClassLoader isolatedInjectableClassLoader = new IsolatedInjectableClassLoader();
        jarFileRelocator.relocate(file, file2);
        JarManifestGenerator.with(file2.toURI()).attribute("Manifest-Version", "1.0").attribute("Agent-Class", string2).generate();
        ApplicationBuilder.injecting("SlimJar-Agent", isolatedInjectableClassLoader).dataProviderFactory(uRL -> ByteBuddyInstrumentationFactory::getDependency).relocatorFactory(collection -> new PassthroughRelocator()).relocationHelperFactory(relocator -> (dependency, file) -> file).build();
        Class<?> clazz = Class.forName(Packages.fix(BYTE_BUDDY_AGENT_CLASS), true, isolatedInjectableClassLoader);
        Method method = clazz.getMethod("attach", File.class, String.class, String.class);
        Class<?> clazz2 = Class.forName("java.lang.ProcessHandle");
        Method method2 = clazz2.getMethod("current", new Class[0]);
        Method method3 = clazz2.getMethod("pid", new Class[0]);
        Object object = method2.invoke(clazz2, new Object[0]);
        Long l = (Long)method3.invoke(object, new Object[0]);
        method.invoke(null, file2, String.valueOf(l), "");
        Class<?> clazz3 = Class.forName(string2, true, ClassLoader.getSystemClassLoader());
        Method method4 = clazz3.getMethod("getInstrumentation", new Class[0]);
        return (Instrumentation)method4.invoke(null, new Object[0]);
    }

    private static DependencyData getDependency() {
        Dependency dependency = new Dependency("net.bytebuddy", "byte-buddy-agent", "1.11.0", null, Collections.emptyList());
        Repository repository = new Repository(new URL("https://repo.maven.apache.org/maven2/"));
        return new DependencyData(Collections.emptySet(), Collections.singleton(repository), Collections.singleton(dependency), Collections.emptyList());
    }

    private static String generatePattern() {
        return String.format("slimjar.%s", UUID.randomUUID().toString());
    }
}

