/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.injector.helper;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import me.glaremasters.guilds.libs.slimjar.downloader.DependencyDownloader;
import me.glaremasters.guilds.libs.slimjar.downloader.DependencyDownloaderFactory;
import me.glaremasters.guilds.libs.slimjar.downloader.output.DependencyOutputWriterFactory;
import me.glaremasters.guilds.libs.slimjar.downloader.strategy.FilePathStrategy;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.DependencyVerifierFactory;
import me.glaremasters.guilds.libs.slimjar.injector.DependencyInjectorFactory;
import me.glaremasters.guilds.libs.slimjar.injector.helper.InjectionHelper;
import me.glaremasters.guilds.libs.slimjar.relocation.Relocator;
import me.glaremasters.guilds.libs.slimjar.relocation.RelocatorFactory;
import me.glaremasters.guilds.libs.slimjar.relocation.helper.RelocationHelper;
import me.glaremasters.guilds.libs.slimjar.relocation.helper.RelocationHelperFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.DependencyResolver;
import me.glaremasters.guilds.libs.slimjar.resolver.DependencyResolverFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.ResolutionResult;
import me.glaremasters.guilds.libs.slimjar.resolver.data.DependencyData;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;
import me.glaremasters.guilds.libs.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.mirrors.MirrorSelector;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;

public final class InjectionHelperFactory {
    private final Path downloadDirectoryPath;
    private final RelocatorFactory relocatorFactory;
    private final RelocationHelperFactory relocationHelperFactory;
    private final DependencyResolverFactory resolverFactory;
    private final RepositoryEnquirerFactory enquirerFactory;
    private final DependencyDownloaderFactory downloaderFactory;
    private final DependencyVerifierFactory verifier;
    private final MirrorSelector mirrorSelector;

    public InjectionHelperFactory(Path path, RelocatorFactory relocatorFactory, DependencyDataProviderFactory dependencyDataProviderFactory, RelocationHelperFactory relocationHelperFactory, DependencyInjectorFactory dependencyInjectorFactory, DependencyResolverFactory dependencyResolverFactory, RepositoryEnquirerFactory repositoryEnquirerFactory, DependencyDownloaderFactory dependencyDownloaderFactory, DependencyVerifierFactory dependencyVerifierFactory, MirrorSelector mirrorSelector) {
        this.downloadDirectoryPath = path;
        this.relocatorFactory = relocatorFactory;
        this.relocationHelperFactory = relocationHelperFactory;
        this.resolverFactory = dependencyResolverFactory;
        this.enquirerFactory = repositoryEnquirerFactory;
        this.downloaderFactory = dependencyDownloaderFactory;
        this.verifier = dependencyVerifierFactory;
        this.mirrorSelector = mirrorSelector;
    }

    public InjectionHelper create(DependencyData dependencyData, Map<String, ResolutionResult> map) {
        Collection<Repository> collection = this.mirrorSelector.select(dependencyData.getRepositories(), dependencyData.getMirrors());
        Relocator relocator = this.relocatorFactory.create(dependencyData.getRelocations());
        RelocationHelper relocationHelper = this.relocationHelperFactory.create(relocator);
        FilePathStrategy filePathStrategy = FilePathStrategy.createDefault(this.downloadDirectoryPath.toFile());
        DependencyOutputWriterFactory dependencyOutputWriterFactory = new DependencyOutputWriterFactory(filePathStrategy);
        DependencyResolver dependencyResolver = this.resolverFactory.create(collection, map, this.enquirerFactory);
        DependencyDownloader dependencyDownloader = this.downloaderFactory.create(dependencyOutputWriterFactory, dependencyResolver, this.verifier.create(dependencyResolver));
        return new InjectionHelper(dependencyDownloader, relocationHelper);
    }
}

