/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.injector.loader;

import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import me.glaremasters.guilds.libs.slimjar.app.builder.ApplicationBuilder;
import me.glaremasters.guilds.libs.slimjar.injector.loader.Injectable;
import me.glaremasters.guilds.libs.slimjar.injector.loader.InstrumentationInjectable;
import me.glaremasters.guilds.libs.slimjar.injector.loader.UnsafeInjectable;
import me.glaremasters.guilds.libs.slimjar.injector.loader.WrappedInjectableClassLoader;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;

public final class InjectableFactory {
    private InjectableFactory() {
    }

    public static Injectable create(Path path, Collection<Repository> collection) {
        return InjectableFactory.create(path, collection, InjectableFactory.class.getClassLoader());
    }

    public static Injectable create(Path path, Collection<Repository> collection, ClassLoader classLoader) {
        boolean bl = InjectableFactory.isJigsawActive();
        Injectable injectable = null;
        if (bl && classLoader instanceof URLClassLoader) {
            injectable = new WrappedInjectableClassLoader((URLClassLoader)ApplicationBuilder.class.getClassLoader());
        } else if (InjectableFactory.isUnsafeAvailable() && classLoader instanceof URLClassLoader) {
            try {
                injectable = UnsafeInjectable.create((URLClassLoader)classLoader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (injectable == null) {
            injectable = InstrumentationInjectable.create(path, collection);
        }
        return injectable;
    }

    private static boolean isJigsawActive() {
        try {
            Class.forName("java.lang.Module");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        return false;
    }

    private static boolean isUnsafeAvailable() {
        try {
            Class.forName("sun.misc.Unsafe");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }
}

